/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.common;

import apex.jorje.semantic.common.iterable.EnclosingTypeIterable;
import apex.jorje.semantic.common.iterable.ExtendedTypeIterable;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.WrapperTypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import java.util.List;

public class TypeInfoUtil {
    private TypeInfoUtil() {
    }

    public static boolean isTopLevel(TypeInfo type) {
        return type.getEnclosingType() == null;
    }

    public static boolean isInnerType(TypeInfo type) {
        return type.getEnclosingType() != null;
    }

    public static TypeInfo getTopLevel(TypeInfo type) {
        return TypeInfoUtil.isTopLevel(type) ? type : type.getEnclosingType();
    }

    public static boolean isInnerTypeOfAnonymous(TypeInfo type) {
        return TypeInfoUtil.isInnerType(type) && type.getEnclosingType().getUnitType() == UnitType.ANONYMOUS;
    }

    public static boolean isTestClass(TypeInfo type) {
        return MoreIterables.ensureAny(new EnclosingTypeIterable(type), input -> input.getModifiers().isTest());
    }

    public static boolean isInTestClass(Member member) {
        return TypeInfoUtil.isTestClass(member.getDefiningType());
    }

    public static boolean isFastCallType(TypeInfo type) {
        return type.isResolved() && (CollectionTypeInfoUtil.isMapOrCollection(type) || TypeInfoEquivalence.isEquivalent(type, WrapperTypeInfos.SYSTEM_LIST_ITERATOR));
    }

    public static boolean isConstructable(TypeInfo type) {
        return !type.methods().constructors().isEmpty();
    }

    public static boolean isAncestor(TypeInfo type, TypeInfo ancestor) {
        for (TypeInfo current : new ExtendedTypeIterable(type)) {
            if (!TypeInfoEquivalence.isEquivalent(current, ancestor)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsPlaceholders(GenericTypeInfo type) {
        return TypeInfoUtil.containsPlaceholders(type.getTypeArguments());
    }

    public static boolean containsPlaceholders(List<TypeInfo> argumentTypes) {
        return MoreIterables.ensureAny(argumentTypes, TypeNameUtil.HAS_PLACEHOLDER);
    }

    public static TypeInfo getEmitType(TypeInfo type) {
        return CollectionTypeInfoUtil.isMapOrCollection(type) ? type : GenericTypeInfoUtil.getRootType(type);
    }

    public static TypeInfo peelType(TypeInfo type) {
        return CollectionTypeInfoUtil.isList(type) ? CollectionTypeInfoUtil.getElementType(type) : type;
    }
}

