/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.common;

import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroupBuilder;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.JavaTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoTables;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.JavaBindingTypeInfos;
import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaTypeInfoUtil {
    private static final JavaTypeInfoUtil INSTANCE = new JavaTypeInfoUtil();
    private final Map<String, TypeInfo> javaToApex;
    private final Map<String, TypeInfo> javaParamTypeToApex;
    private final Map<String, TypeInfo> javaEmitReturnTypeToApex;
    private final Map<String, TypeInfo> javaReturnTypeToApex;
    private final Map<Equivalence.Wrapper<? extends TypeInfo>, Class<?>> apexToJava;
    private final Map<Class<?>, TypeInfo> classToJavaType = Maps.newHashMap();

    private JavaTypeInfoUtil() {
        this.javaToApex = ImmutableMap.builder().put(String.class.getName(), TypeInfos.STRING).put(Integer.class.getName(), TypeInfos.INTEGER).put(Long.class.getName(), TypeInfos.LONG).put(Double.class.getName(), TypeInfos.DOUBLE).put(BigDecimal.class.getName(), TypeInfos.DECIMAL).put(Boolean.class.getName(), TypeInfos.BOOLEAN).put(Object.class.getName(), TypeInfos.OBJECT).put("common.apex.runtime.ApexObject", TypeInfos.OBJECT).put("common.apex.runtime.ApexValue", TypeInfos.OBJECT).put(Void.class.getName(), TypeInfos.VOID).put(Pattern.class.getName(), (ScalarTypeInfo)((Object)InternalTypeInfos.SYSTEM_PATTERN)).put(Matcher.class.getName(), (ScalarTypeInfo)((Object)InternalTypeInfos.SYSTEM_MATCHER)).put(GregorianCalendar.class.getName(), TypeInfos.DATE_TIME).put(TypeInfos.DATE_TIME.getBytecodeName().replace('/', '.'), TypeInfos.DATE_TIME).put(TypeInfos.DATE.getBytecodeName().replace('/', '.'), TypeInfos.DATE).put(TypeInfos.TIME.getBytecodeName().replace('/', '.'), TypeInfos.TIME).put(TypeInfos.ID.getBytecodeName().replace('/', '.'), TypeInfos.ID).put("core.filemanager.ByteBlobValue", TypeInfos.BLOB).put(TypeInfos.BLOB.getBytecodeName().replace('/', '.'), TypeInfos.BLOB).put("common.apex.visualforce.Component", (ScalarTypeInfo)((Object)InternalTypeInfos.APEX_PAGES_COMPONENT)).build();
        this.javaReturnTypeToApex = ImmutableMap.builder().put(Date.class.getName(), TypeInfos.DATE_TIME).put("common.apex.runtime.SObjectRow", TypeInfos.SOBJECT).put("common.apex.runtime.impl.MapValue", (ScalarTypeInfo)((Object)ReifiedTypeInfos.STRING_TO_STRING_MAP)).put("common.apex.runtime.impl.IMapValue", (ScalarTypeInfo)((Object)ReifiedTypeInfos.STRING_TO_STRING_MAP)).put("common.apex.runtime.bytecode.DeferredMarshalingMapValueImpl", (ScalarTypeInfo)((Object)ReifiedTypeInfos.STRING_TO_STRING_MAP)).build();
        this.javaParamTypeToApex = new HashMap<String, ScalarTypeInfo>(ImmutableMap.builder().put(Date.class.getName(), TypeInfos.DATE).put("common.apex.runtime.SObjectRow", TypeInfos.SOBJECT).put("common.apex.runtime.ListValue", (ScalarTypeInfo)((Object)TypeInfos.LIST)).put("common.apex.runtime.impl.SetValue", (ScalarTypeInfo)((Object)TypeInfos.SET)).put("common.apex.runtime.impl.MapValue", (ScalarTypeInfo)((Object)ReifiedTypeInfos.STRING_TO_OBJECT_MAP)).build());
        this.javaEmitReturnTypeToApex = ImmutableMap.builder().put(Date.class.getName(), TypeInfos.DATE_TIME).put("common.apex.runtime.SObjectRow", (ScalarTypeInfo)((Object)JavaBindingTypeInfos.RUNTIME_SOBJECT_ROW)).put("common.apex.runtime.impl.MapValue", (ScalarTypeInfo)((Object)ReifiedTypeInfos.STRING_TO_STRING_MAP)).put("common.apex.runtime.impl.IMapValue", (ScalarTypeInfo)((Object)JavaBindingTypeInfos.RUNTIME_MAP)).put("common.apex.runtime.bytecode.DeferredMarshalingMapValueImpl", (ScalarTypeInfo)((Object)JavaBindingTypeInfos.RUNTIME_MAP)).build();
        this.apexToJava = new HashMap();
    }

    public static JavaTypeInfoUtil get() {
        return INSTANCE;
    }

    @SfdcCalled
    public void addJavaToApexParamMapping(Class<?> clazz, TypeInfo typeInfo) {
        this.javaParamTypeToApex.put(clazz.getName(), typeInfo);
    }

    public TypeInfo fromJavaType(Class<?> clazz, TypeUsage usage) {
        TypeInfo type = this.javaToApex.get(this.getClassName(clazz));
        if (type != null) {
            return type;
        }
        switch (usage) {
            case AS_PARAMETER: {
                return this.javaParamTypeToApex.get(this.getClassName(clazz));
            }
            case AS_RETURN: {
                return this.javaReturnTypeToApex.get(this.getClassName(clazz));
            }
            case AS_EMIT_RETURN: {
                return this.javaEmitReturnTypeToApex.get(this.getClassName(clazz));
            }
        }
        throw new UnexpectedCodePathException();
    }

    public Class<?> getBoxedType(Class<?> clazz) {
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        return clazz;
    }

    public TypeInfo getOrCreate(Class<?> clazz) {
        TypeInfo type = this.fromJavaType(clazz, TypeUsage.AS_PARAMETER);
        if (type == null) {
            return this.createJava(clazz);
        }
        return type;
    }

    public TypeInfo mapType(Class<?> clazz, TypeUsage usedAs) {
        String className = this.getClassName(clazz);
        if (Pattern.class.equals(clazz) || Matcher.class.equals(clazz) || "common.apex.visualforce.Component".equals(className) || "common.apex.runtime.ApexValue".equals(className) || "common.apex.runtime.ApexObject".equals(className)) {
            return this.createJava(clazz);
        }
        TypeInfo apexType = this.fromJavaType(this.getBoxedType(clazz), usedAs);
        if (apexType != null) {
            return apexType;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            switch (usedAs) {
                case AS_PARAMETER: {
                    return ReifiedTypeInfos.STRING_TO_OBJECT_MAP;
                }
                case AS_RETURN: {
                    return ReifiedTypeInfos.STRING_TO_STRING_MAP;
                }
                case AS_EMIT_RETURN: {
                    return JavaBindingTypeInfos.RUNTIME_MAP;
                }
            }
            throw new UnexpectedCodePathException();
        }
        if (List.class.isAssignableFrom(clazz)) {
            switch (usedAs) {
                case AS_PARAMETER: {
                    return ReifiedTypeInfos.OBJECT_LIST;
                }
                case AS_RETURN: 
                case AS_EMIT_RETURN: {
                    return this.createJava(clazz);
                }
            }
            throw new UnexpectedCodePathException();
        }
        if (Set.class.isAssignableFrom(clazz)) {
            switch (usedAs) {
                case AS_PARAMETER: {
                    return ReifiedTypeInfos.OBJECT_SET;
                }
                case AS_RETURN: 
                case AS_EMIT_RETURN: {
                    return this.createJava(clazz);
                }
            }
            throw new UnexpectedCodePathException();
        }
        if ("apex.bytecodeinterpreter.ObjectInstance".equals(className)) {
            return TypeInfos.OBJECT;
        }
        return this.createJava(clazz);
    }

    public List<TypeInfo> mapTypes(List<Class<?>> clazzes) {
        return clazzes.stream().map(clazz -> this.mapType((Class<?>)clazz, TypeUsage.AS_PARAMETER)).collect(MoreIterables.toUnmodifiableList(clazzes.size()));
    }

    public TypeInfo createJava(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        Class<?> boxedClass = this.getBoxedType(clazz);
        if (Void.class.equals(boxedClass)) {
            return TypeInfos.VOID;
        }
        TypeInfo type = this.classToJavaType.get(boxedClass);
        if (type == null) {
            type = JavaTypeInfo.create(boxedClass);
            this.classToJavaType.put(boxedClass, type);
        }
        return type;
    }

    private String getClassName(Class clazz) {
        return clazz.getName();
    }

    public Set<TypeInfo> createJava(Class<?> ... clazzes) {
        HashSet<TypeInfo> retValue = new HashSet<TypeInfo>();
        for (Class<?> clazz : clazzes) {
            retValue.add(this.createJava(clazz));
        }
        return retValue;
    }

    public Class lookupClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException x) {
            return null;
        }
    }

    public ModifierGroup createModifiers(int modifiers) {
        ModifierGroupBuilder builder = ModifierGroup.builder();
        TypeInfoTables.MODIFIER_TYPES.values().stream().filter(modifier -> (modifier.getOpcode() & modifiers) > 0).forEach(xva$0 -> builder.addModifiers((ModifierTypeInfo)xva$0));
        builder.addModifiers(ModifierTypeInfos.GLOBAL);
        return builder.build();
    }

    public Class<?> fromApexType(TypeInfo apexType) {
        Class clazz;
        if (this.apexToJava.containsKey(apexType.getEquivalenceWrapper())) {
            return this.apexToJava.get(apexType.getEquivalenceWrapper());
        }
        switch (apexType.getBasicType()) {
            case LIST: {
                clazz = List.class;
                break;
            }
            case SET: {
                clazz = Set.class;
                break;
            }
            case MAP: {
                clazz = Map.class;
                break;
            }
            default: {
                try {
                    clazz = Class.forName(apexType.getBytecodeName().replace("/", "."));
                    break;
                }
                catch (ClassNotFoundException x) {
                    clazz = null;
                }
            }
        }
        this.apexToJava.put(apexType.getEquivalenceWrapper(), clazz);
        return clazz;
    }

    public static enum TypeUsage {
        AS_PARAMETER,
        AS_RETURN,
        AS_EMIT_RETURN;

    }
}

