/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.common;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfos;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.tester.TestConstants;
import apex.jorje.services.Version;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class GenericTypeInfoUtilTest {
    @Test
    public void testNotInterfaceIsUserGenericInterface() {
        GenericTypeInfo type = ((GenericTypeInfo.Builder)GenericTypeInfo.builder().setFileBase(TestConstants.EMPTY_SOURCE, CompilationUnitBuilder.emptyClass((String)"foo"))).setTypeArguments(ArgumentTypeInfos.T).build();
        GenericTypeInfo genericType = GenericTypeInfoFactory.create((TypeInfo)type, TypeInfos.OBJECT);
        MatcherAssert.assertThat((Object)GenericTypeInfoUtil.isUserGenericInterface(genericType), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testNotUserDefinedIsUserGenericInterface() {
        GenericTypeInfo genericType = GenericTypeInfoFactory.create((TypeInfo)TypeInfos.LIST, TypeInfos.OBJECT);
        MatcherAssert.assertThat((Object)GenericTypeInfoUtil.isUserGenericInterface(genericType), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testNotGenericIsUserGenericInterface() {
        MatcherAssert.assertThat((Object)GenericTypeInfoUtil.isUserGenericInterface(TypeInfos.OBJECT), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testTrustedGenericInterface() {
        GenericTypeInfo type = ((GenericTypeInfo.Builder)GenericTypeInfo.builder().setTypeArguments(ArgumentTypeInfos.T).setFileBase(TestConstants.TRUSTED_SOURCE, CompilationUnitBuilder.emptyInterface((String)"foo"))).buildResolved();
        MatcherAssert.assertThat((Object)GenericTypeInfoUtil.isUserGenericInterface(type), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testFileBaseGenericInterface() {
        GenericTypeInfo type = ((GenericTypeInfo.Builder)GenericTypeInfo.builder().setTypeArguments(ArgumentTypeInfos.T).setFileBase(TestConstants.FILE_BASE_SOURCE, CompilationUnitBuilder.emptyInterface((String)"foo"))).buildResolved();
        MatcherAssert.assertThat((Object)GenericTypeInfoUtil.isUserGenericInterface(type), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsUserGenericInterface() {
        GenericTypeInfo type = ((GenericTypeInfo.Builder)GenericTypeInfo.builder().setTypeArguments(ArgumentTypeInfos.T).setFileBase(TestConstants.EMPTY_SOURCE, CompilationUnitBuilder.emptyInterface((String)"foo"))).buildResolved();
        MatcherAssert.assertThat((Object)GenericTypeInfoUtil.isUserGenericInterface(type), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGenericInterfacesAllowedBeforeV180() {
        GenericTypeInfo type = ((GenericTypeInfo.Builder)GenericTypeInfo.builder().setTypeArguments(ArgumentTypeInfos.T).setFileBase(SourceFile.builder().setVersion(Version.V178).build(), CompilationUnitBuilder.emptyInterface((String)"foo"))).buildResolved();
        MatcherAssert.assertThat((Object)GenericTypeInfoUtil.typeParametersAllowed(false, type.getCodeUnitDetails()), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGenericInterfacesAllowedIfTrusted() {
        GenericTypeInfo type = ((GenericTypeInfo.Builder)GenericTypeInfo.builder().setTypeArguments(ArgumentTypeInfos.T).setFileBase(SourceFile.builder().setTrusted(true).build(), CompilationUnitBuilder.emptyInterface((String)"foo"))).buildResolved();
        MatcherAssert.assertThat((Object)GenericTypeInfoUtil.typeParametersAllowed(false, type.getCodeUnitDetails()), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGenericInterfacesDisallowedV180() {
        GenericTypeInfo type = ((GenericTypeInfo.Builder)GenericTypeInfo.builder().setTypeArguments(ArgumentTypeInfos.T).setFileBase(SourceFile.builder().setVersion(Version.V180).build(), CompilationUnitBuilder.emptyInterface((String)"foo"))).buildResolved();
        MatcherAssert.assertThat((Object)GenericTypeInfoUtil.typeParametersAllowed(false, type.getCodeUnitDetails()), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testHasApexParameterizedTypes() {
        GenericTypeInfo type = ((GenericTypeInfo.Builder)GenericTypeInfo.builder().setTypeArguments(ArgumentTypeInfos.T).setFileBase(SourceFile.builder().setVersion(Version.V182).build(), CompilationUnitBuilder.emptyClass((String)"foo"))).buildResolved();
        MatcherAssert.assertThat((Object)GenericTypeInfoUtil.typeParametersAllowed(true, type.getCodeUnitDetails()), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGenericClassesDisallowedBeforeV180() {
        GenericTypeInfo type = ((GenericTypeInfo.Builder)GenericTypeInfo.builder().setTypeArguments(ArgumentTypeInfos.T).setFileBase(SourceFile.builder().setVersion(Version.V178).build(), CompilationUnitBuilder.emptyClass((String)"foo"))).buildResolved();
        MatcherAssert.assertThat((Object)GenericTypeInfoUtil.typeParametersAllowed(false, type.getCodeUnitDetails()), (Matcher)Matchers.is((Object)false));
    }

    @DataProvider
    Object[][] reifiedTypeData() {
        return new Object[][]{{TypeInfos.LIST, false}, {GenericTypeInfoFactory.createList(TypeInfos.INTEGER), true}, {GenericTypeInfoFactory.createMap(TypeInfos.STRING, ArgumentTypeInfos.T), false}, {GenericTypeInfoFactory.createMap(TypeInfos.STRING, TypeInfos.INTEGER), true}, {TypeInfos.STRING, true}, {ArgumentTypeInfos.T, false}};
    }

    @Test(dataProvider="reifiedTypeData")
    public void testReifiedType(TypeInfo type, boolean expected) {
        MatcherAssert.assertThat((Object)GenericTypeInfoUtil.isReifiedType(type), (Matcher)Matchers.is((Object)expected));
    }
}

