/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.common;

import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfos;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.tester.matchers.IsType;
import org.hamcrest.MatcherAssert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class CollectionTypeInfoUtilTest {
    @DataProvider
    Object[][] getElementTypeData() {
        return new Object[][]{{ReifiedTypeInfos.SOBJECT_LIST, TypeInfos.SOBJECT}, {ReifiedTypeInfos.STRING_SET, TypeInfos.STRING}, {TypeInfos.SET, ArgumentTypeInfos.T}, {TypeInfos.LIST, ArgumentTypeInfos.T}};
    }

    @Test(dataProvider="getElementTypeData")
    public void testGetElementType(TypeInfo type, TypeInfo expectedElementType) {
        MatcherAssert.assertThat((Object)CollectionTypeInfoUtil.getElementType(type), IsType.isType(expectedElementType));
    }

    @Test(expectedExceptions={UnexpectedCodePathException.class})
    public void testInvalidGetElementType() {
        CollectionTypeInfoUtil.getElementType(TypeInfos.INTEGER);
    }
}

