/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.common;

import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.common.iterator.EqualPairIterator;
import apex.jorje.semantic.common.iterator.Pair;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ArgumentTypeInfoConverter {
    public static List<Parameter> convertParameters(List<Parameter> parameters) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter parameter : parameters) {
            builder.add(Parameter.builder().setDefiningType(parameter.getDefiningType()).setType(ArgumentTypeInfoConverter.convertType(parameter.getType())).setName(parameter.getName()).setModifiers(parameter.getModifierInfo()).build());
        }
        return builder.build();
    }

    public static List<Parameter> convertParameters(Map<Equivalence.Wrapper<? extends TypeInfo>, TypeInfo> oldTypeToNewType, List<Parameter> parameters) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter parameter : parameters) {
            builder.add(Parameter.builder().setDefiningType(parameter.getDefiningType()).setType(ArgumentTypeInfoConverter.convertType(oldTypeToNewType, parameter.getType())).setName(parameter.getName()).setModifiers(parameter.getModifierInfo()).build());
        }
        return builder.build();
    }

    public static TypeInfo convertType(final Map<Equivalence.Wrapper<? extends TypeInfo>, TypeInfo> oldTypeToNewType, TypeInfo type) {
        return type.accept(new TypeInfoVisitor.Default<TypeInfo>(){

            @Override
            protected TypeInfo _default(TypeInfo type) {
                return type;
            }

            @Override
            public TypeInfo visit(GenericTypeInfo type) {
                ArrayList<TypeInfo> transformedArgumentTypes = Lists.newArrayList();
                for (TypeInfo argumentType : type.getTypeArguments()) {
                    transformedArgumentTypes.add(ArgumentTypeInfoConverter.convertType(oldTypeToNewType, argumentType));
                }
                return GenericTypeInfoFactory.create((TypeInfo)type, transformedArgumentTypes);
            }

            @Override
            public TypeInfo visit(ArgumentTypeInfo type) {
                if (oldTypeToNewType.containsKey(type.getEquivalenceWrapper())) {
                    return (TypeInfo)oldTypeToNewType.get(type.getEquivalenceWrapper());
                }
                throw new IllegalArgumentException("Could not convert type " + type + ". No Mapping found. Known types are: " + TypeInfoEquivalence.unwrapSet(oldTypeToNewType.keySet()).stream().map(TypeInfo.TO_APEX_NAME).collect(Collectors.joining(",", "[", "]")));
            }
        });
    }

    public static TypeInfo convertType(TypeInfo type) {
        return type.accept(new TypeInfoVisitor.Default<TypeInfo>(){

            @Override
            public TypeInfo visit(GenericTypeInfo type) {
                ArrayList<TypeInfo> transformedArgumentTypes = Lists.newArrayList();
                for (TypeInfo argumentType : type.getTypeArguments()) {
                    transformedArgumentTypes.add(ArgumentTypeInfoConverter.convertType(argumentType));
                }
                return GenericTypeInfoFactory.create((TypeInfo)type, transformedArgumentTypes);
            }

            @Override
            protected TypeInfo _default(TypeInfo type) {
                return type;
            }

            @Override
            public TypeInfo visit(ArgumentTypeInfo type) {
                return TypeInfos.OBJECT;
            }
        });
    }

    public static List<TypeInfo> convertListSetMapTypes(List<TypeInfo> type) {
        return type.stream().map(ArgumentTypeInfoConverter::convertListSetMapType).collect(MoreIterables.toUnmodifiableList(type.size()));
    }

    public static TypeInfo convertListSetMapType(TypeInfo type) {
        return type.accept(new TypeInfoVisitor.Default<TypeInfo>(){

            @Override
            public TypeInfo visit(GenericTypeInfo type) {
                switch (type.getBasicType()) {
                    case LIST: 
                    case SET: 
                    case MAP: {
                        List<TypeInfo> transformedArgumentTypes = type.getTypeArguments().stream().map(ArgumentTypeInfoConverter::convertListSetMapType).collect(MoreIterables.toUnmodifiableList(type.getTypeArguments().size()));
                        return GenericTypeInfoFactory.create((TypeInfo)type, transformedArgumentTypes);
                    }
                }
                return type;
            }

            @Override
            protected TypeInfo _default(TypeInfo type) {
                return type;
            }

            @Override
            public TypeInfo visit(ArgumentTypeInfo type) {
                return TypeInfos.OBJECT;
            }
        });
    }

    public static Map<Equivalence.Wrapper<? extends TypeInfo>, TypeInfo> getResolutionMap(GenericTypeInfo targetType, TypeInfo rootUnreifiedType) {
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        for (final Pair<TypeInfo, TypeInfo> pair : EqualPairIterator.iterable(rootUnreifiedType.getTypeArguments(), targetType.getTypeArguments())) {
            ((TypeInfo)pair.left).accept(new TypeInfoVisitor.Default<Void>(){

                @Override
                protected Void _default(TypeInfo type) {
                    throw new IllegalArgumentException("The placeholder type must only contain ArgumentTypeInfo, but found a type of class: " + ((TypeInfo)pair.left).getClass().getSimpleName());
                }

                @Override
                public Void visit(ArgumentTypeInfo type) {
                    builder.put(type.getEquivalenceWrapper(), pair.right);
                    return null;
                }
            });
        }
        return builder.build();
    }
}

