/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoDepthCalculator;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UnresolvedErrorCalculator {
    public static List<String> getErrors(List<TypeInfo> types) {
        ArrayList<String> errors = Lists.newArrayList();
        for (TypeInfo type : types) {
            if (type.isResolved()) continue;
            errors.addAll(UnresolvedErrorCalculator.getErrors(type));
        }
        return errors;
    }

    public static List<String> getErrors(TypeInfo type) {
        assert (!type.isResolved()) : "asking for unresolved errors on a resolved type";
        return type.accept(new TypeInfoVisitor.Default<List<String>>(){

            @Override
            protected List<String> _default(TypeInfo type) {
                return Collections.singletonList(I18nSupport.getLabel("invalid.unresolved.type", type));
            }

            @Override
            public List<String> visit(GenericTypeInfo type) {
                TypeInfo unreifiedType = type.getUnreifiedType();
                if (unreifiedType == null) {
                    return Collections.singletonList(TypeInfoUtil.containsPlaceholders(type) ? I18nSupport.getLabel("invalid.unresolved.type", type.getApexName()) : I18nSupport.getLabel("type.arguments.for.non.parameterized.type", TypeNameUtil.nonGenericApexName(type)));
                }
                ArrayList<String> errors = Lists.newArrayList();
                if (!unreifiedType.isResolved()) {
                    return UnresolvedErrorCalculator.getErrors(unreifiedType);
                }
                if (type.getTypeArguments().isEmpty()) {
                    assert (!unreifiedType.getTypeArguments().isEmpty()) : "we created an unresolved type that was resolved";
                    errors.add(I18nSupport.getLabel("no.type.arguments.for.parameterized.type", type));
                    return errors;
                }
                int argumentCount = unreifiedType.getTypeArguments().size();
                if (argumentCount == 0) {
                    errors.add(I18nSupport.getLabel("type.arguments.for.non.parameterized.type", TypeNameUtil.nonGenericApexName(type)));
                } else if (argumentCount != type.getTypeArguments().size()) {
                    errors.add(I18nSupport.getLabel("invalid.parameterized.type.count", TypeNameUtil.nonGenericApexName(type), argumentCount, type.getTypeArguments().size()));
                } else {
                    int depth = GenericTypeInfoDepthCalculator.calculate(type);
                    if (depth > GenericTypeInfo.MAX_SIZE) {
                        return Collections.singletonList(I18nSupport.getLabel("parameterized.type.too.deep", type, depth));
                    }
                    for (TypeInfo argumentType : type.getTypeArguments()) {
                        if (argumentType.isResolved()) continue;
                        errors.addAll(UnresolvedErrorCalculator.getErrors(argumentType));
                    }
                }
                assert (!errors.isEmpty()) : "we are not resolved but there were no errors";
                return errors;
            }
        });
    }
}

