/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.type.AbstractTypeInfo;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfo;
import apex.jorje.semantic.symbol.type.FlowInterviewTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.JavaTypeInfo;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.VfComponentTypeInfo;
import apex.jorje.semantic.symbol.type.WrapperTypeInfo;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.semantic.tester.TestStandardTypeInfos;
import apex.jorje.semantic.tester.matchers.IsType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TypeInfoEquivalenceTest {
    private static TypeInfo generic(String name, TypeInfo ... types) {
        return ((GenericTypeInfo.Builder)GenericTypeInfo.builder().setApexBytecodeName(name)).setTypeArguments(types).buildResolved();
    }

    private static TypeInfo flow(String name) {
        return ((FlowInterviewTypeInfo.Builder)((FlowInterviewTypeInfo.Builder)FlowInterviewTypeInfo.builder().setParents(InternalTypeInfos.FLOW_INTERVIEW)).setFlowName(name).setApexBytecodeName(name)).buildResolved();
    }

    private static TypeInfo sobject(String name) {
        return ((SObjectTypeInfo.Builder)((SObjectTypeInfo.Builder)SObjectTypeInfo.builder().setResolvedDefaults()).setApexBytecodeName(name)).buildResolved();
    }

    private static TypeInfo java(Class<?> clazz) {
        return JavaTypeInfo.builder().setClass(clazz).build();
    }

    private static TypeInfo argument(String name) {
        return ArgumentTypeInfo.create(name);
    }

    private static TypeInfo standard(String name) {
        return ((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName(name)).buildResolved();
    }

    private static TypeInfo internal(String name, TypeInfo ... types) {
        return ((InternalTypeInfo.Builder)InternalTypeInfo.builder().setApexBytecodeName(name)).setTypeArguments(types).buildResolved();
    }

    private static TypeInfo wrapper(String name, Class<?> clazz) {
        return ((TestWrapperTypeInfo.Builder)TestWrapperTypeInfo.builder().setApexBytecodeName(name)).setJavaType(clazz).buildResolved();
    }

    private static TypeInfo vf(String name) {
        return ((VfComponentTypeInfo.Builder)((VfComponentTypeInfo.Builder)VfComponentTypeInfo.builder().setVfComponentName(name).setNamespace(Namespaces.APEX)).setParents(TestStandardTypeInfos.APEX_PAGES_COMPONENT)).buildResolved();
    }

    @DataProvider
    Object[][] nonEquivalentTypes() {
        return new Object[][]{{TypeInfoEquivalenceTest.standard("foo"), TypeInfoEquivalenceTest.standard("bar")}, {TypeInfoEquivalenceTest.argument("foo"), TypeInfoEquivalenceTest.argument("bar")}, {TypeInfoEquivalenceTest.internal("foo", new TypeInfo[0]), TypeInfoEquivalenceTest.internal("bar", new TypeInfo[0])}, {TypeInfoEquivalenceTest.java(String.class), TypeInfoEquivalenceTest.java(Integer.class)}, {TypeInfoEquivalenceTest.generic("foo", TypeInfoEquivalenceTest.standard("U")), TypeInfoEquivalenceTest.generic("foo", TypeInfoEquivalenceTest.standard("T"))}, {TypeInfoEquivalenceTest.standard("foo"), TypeInfoEquivalenceTest.generic("foo", TypeInfoEquivalenceTest.argument("T"))}, {TypeInfoEquivalenceTest.standard("Flow/Interview/dynamic_Flow.Interview.foo"), TypeInfoEquivalenceTest.flow("foo")}, {TypeInfoEquivalenceTest.standard("com/salesforce/api/VisualForceComponent/Component/apex/foo"), TypeInfoEquivalenceTest.vf("foo")}, {TypeInfoEquivalenceTest.standard("com/salesforce/api/entity/foo"), TypeInfoEquivalenceTest.sobject("foo")}, {TypeInfoEquivalenceTest.standard("java/lang/String"), TypeInfos.STRING}, {TypeInfoEquivalenceTest.standard("foo"), TypeInfoEquivalenceTest.argument("foo")}};
    }

    @Test(dataProvider="nonEquivalentTypes")
    public void testNonEquivalent(TypeInfo thisType, TypeInfo thatType) {
        MatcherAssert.assertThat((Object)thisType, (Matcher)Matchers.not(IsType.isType(thatType)));
        MatcherAssert.assertThat((Object)thatType, (Matcher)Matchers.not(IsType.isType(thisType)));
    }

    @DataProvider
    Object[][] equivalentTypes() {
        return new Object[][]{{TypeInfoEquivalenceTest.standard("foo"), TypeInfoEquivalenceTest.standard("foo")}, {TypeInfoEquivalenceTest.internal("foo", new TypeInfo[0]), TypeInfoEquivalenceTest.standard("foo")}, {TypeInfoEquivalenceTest.java(String.class), TypeInfoEquivalenceTest.standard("java/lang/String")}, {TypeInfoEquivalenceTest.java(String.class), TypeInfoEquivalenceTest.wrapper("bar", String.class)}, {TypeInfoEquivalenceTest.sobject("foo"), TypeInfoEquivalenceTest.sobject("foo")}, {TypeInfoEquivalenceTest.internal("com/salesforce/api/entity/foo", new TypeInfo[0]), TypeInfoEquivalenceTest.sobject("foo")}, {TypeInfos.STRING, TypeInfos.STRING}, {TypeInfoEquivalenceTest.java(String.class), TypeInfos.STRING}, {TypeInfoEquivalenceTest.java(String.class), TypeInfoEquivalenceTest.java(String.class)}, {TypeInfoEquivalenceTest.internal("foo", new TypeInfo[0]), TypeInfoEquivalenceTest.internal("foo", new TypeInfo[0])}, {TypeInfoEquivalenceTest.argument("foo"), TypeInfoEquivalenceTest.argument("foo")}, {TypeInfoEquivalenceTest.generic("foo", TypeInfoEquivalenceTest.argument("T")), TypeInfoEquivalenceTest.generic("foo", TypeInfoEquivalenceTest.argument("T"))}, {TypeInfoEquivalenceTest.internal("foo", TypeInfoEquivalenceTest.argument("T")), TypeInfoEquivalenceTest.generic("foo", TypeInfoEquivalenceTest.argument("T"))}, {TypeInfoEquivalenceTest.flow("foo"), TypeInfoEquivalenceTest.flow("foo")}, {TypeInfoEquivalenceTest.vf("foo"), TypeInfoEquivalenceTest.vf("foo")}};
    }

    @Test(dataProvider="equivalentTypes")
    public void testEquivalent(TypeInfo thisType, TypeInfo thatType) {
        MatcherAssert.assertThat((Object)thisType, IsType.isType(thatType));
        MatcherAssert.assertThat((Object)thatType, IsType.isType(thisType));
    }

    public static class TestWrapperTypeInfo
    extends AbstractTypeInfo
    implements WrapperTypeInfo,
    StandardTypeInfo {
        private final Class<?> javaType;

        private TestWrapperTypeInfo(Builder builder) {
            super(builder);
            this.javaType = builder.javaType;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Override
        public Class<?> getJavaType() {
            return this.javaType;
        }

        @Override
        public <T> T accept(TypeInfoVisitor<T> visitor) {
            return visitor.visit(this);
        }

        public static class Builder
        extends AbstractTypeInfo.Builder<Builder, TestWrapperTypeInfo> {
            private Class<?> javaType;

            private Builder() {
            }

            public Builder setJavaType(Class<?> javaType) {
                this.javaType = javaType;
                return this;
            }

            @Override
            public TestWrapperTypeInfo build() {
                this.setApexBytecodeName(this.javaType.getSimpleName());
                return new TestWrapperTypeInfo(this);
            }
        }
    }
}

