/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfo;
import apex.jorje.semantic.symbol.type.FlowInterviewTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfo;
import apex.jorje.semantic.symbol.type.JavaTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.VfComponentTypeInfo;
import apex.jorje.semantic.symbol.type.WrapperTypeInfo;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import com.google.common.base.Equivalence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class TypeInfoEquivalence
extends Equivalence<TypeInfo> {
    public static boolean isEquivalent(TypeInfo left, TypeInfo right) {
        if (left == right) {
            return true;
        }
        TypeInfoVisitor<Boolean> comparison = left.accept(CalculateEquivalenceInputTypeVisitor.get());
        return right.accept(comparison);
    }

    private static boolean equivalentBytecodeName(TypeInfo typeA, TypeInfo typeB) {
        return typeA.isResolved() == typeB.isResolved() && typeA.getBytecodeName().equals(typeB.getBytecodeName());
    }

    private static boolean equivalentApexName(TypeInfo left, TypeInfo right) {
        return left.isResolved() == right.isResolved() && left.getApexName().equals(right.getApexName());
    }

    private static Boolean isStandardTypeEquivalentToJavaType(StandardTypeInfo standardType, JavaTypeInfo javaType) {
        Class<?> otherClass;
        if (standardType instanceof WrapperTypeInfo && (otherClass = ((WrapperTypeInfo)((Object)standardType)).getJavaType()) != null) {
            Class<?> thisClass = javaType.getJavaType();
            return otherClass.isAssignableFrom(thisClass);
        }
        return TypeInfoEquivalence.equivalentBytecodeName(standardType, javaType);
    }

    public static List<Equivalence.Wrapper<? extends TypeInfo>> wrapAll(List<TypeInfo> types) {
        ArrayList<Equivalence.Wrapper<? extends TypeInfo>> builder = new ArrayList<Equivalence.Wrapper<? extends TypeInfo>>();
        for (int i = 0; i < types.size(); ++i) {
            builder.add(types.get(i).getEquivalenceWrapper());
        }
        return Collections.unmodifiableList(builder);
    }

    public static Set<Equivalence.Wrapper<? extends TypeInfo>> wrapAllAsSet(TypeInfo ... types) {
        return Arrays.stream(types).map(TypeInfo::getEquivalenceWrapper).collect(MoreIterables.toUnmodifiableOrderedSet(types.length));
    }

    public static <T extends TypeInfo> Set<T> unwrapSet(Set<Equivalence.Wrapper<? extends TypeInfo>> wrappers) {
        return wrappers.stream().map(wrapper -> (TypeInfo)wrapper.get()).collect(MoreIterables.toUnmodifiableOrderedSet(wrappers.size()));
    }

    public static boolean containsEquivalent(Set<TypeInfo> types, TypeInfo searchTarget) {
        return MoreIterables.ensureAny(types, type -> TypeInfoEquivalence.isEquivalent(type, searchTarget));
    }

    @Override
    protected boolean doEquivalent(TypeInfo left, TypeInfo right) {
        return TypeInfoEquivalence.isEquivalent(right, left);
    }

    @Override
    protected int doHash(TypeInfo type) {
        return type.getBytecodeName().hashCode();
    }

    static class BytecodeNameEquivalence
    extends TypeInfoVisitor.Default<Boolean> {
        private final TypeInfo left;

        public BytecodeNameEquivalence(TypeInfo left) {
            this.left = left;
        }

        @Override
        protected Boolean _default(TypeInfo right) {
            return this.left.getClass() == right.getClass() && TypeInfoEquivalence.equivalentBytecodeName(this.left, right);
        }
    }

    static class ApexNameEquivalence
    extends TypeInfoVisitor.Default<Boolean> {
        private final TypeInfo left;

        public ApexNameEquivalence(TypeInfo left) {
            this.left = left;
        }

        @Override
        protected Boolean _default(TypeInfo right) {
            return this.left.getClass() == right.getClass() && TypeInfoEquivalence.equivalentApexName(this.left, right);
        }
    }

    static class InputGenericTypeVisitor
    extends TypeInfoVisitor.Default<Boolean> {
        private final GenericTypeInfo left;

        public InputGenericTypeVisitor(GenericTypeInfo left) {
            this.left = left;
        }

        @Override
        protected Boolean _default(TypeInfo right) {
            return false;
        }

        @Override
        public Boolean visit(InternalTypeInfo right) {
            return TypeInfoEquivalence.equivalentBytecodeName(this.left, right);
        }

        @Override
        public Boolean visit(GenericTypeInfo right) {
            return TypeInfoEquivalence.equivalentBytecodeName(this.left, right);
        }
    }

    static class InputScalarTypeVisitor
    extends TypeInfoVisitor.Default<Boolean> {
        private final ScalarTypeInfo left;

        public InputScalarTypeVisitor(ScalarTypeInfo left) {
            this.left = left;
        }

        @Override
        protected Boolean _default(TypeInfo right) {
            return false;
        }

        @Override
        public Boolean visit(JavaTypeInfo right) {
            return TypeInfoEquivalence.equivalentBytecodeName(this.left, right);
        }

        @Override
        public Boolean visit(ScalarTypeInfo right) {
            return TypeInfoEquivalence.equivalentBytecodeName(this.left, right);
        }
    }

    static class InputSObjectTypeVisitor
    extends TypeInfoVisitor.Default<Boolean> {
        private final SObjectTypeInfo left;

        public InputSObjectTypeVisitor(SObjectTypeInfo left) {
            this.left = left;
        }

        @Override
        protected Boolean _default(TypeInfo right) {
            return false;
        }

        @Override
        public Boolean visit(InternalTypeInfo right) {
            return TypeInfoEquivalence.equivalentBytecodeName(this.left, right);
        }

        @Override
        public Boolean visit(SObjectTypeInfo right) {
            return TypeInfoEquivalence.equivalentBytecodeName(this.left, right);
        }
    }

    static class InputInternalTypeVisitor
    extends TypeInfoVisitor.Default<Boolean> {
        private final InternalTypeInfo left;

        public InputInternalTypeVisitor(InternalTypeInfo left) {
            this.left = left;
        }

        @Override
        protected Boolean _default(TypeInfo right) {
            return false;
        }

        @Override
        public Boolean visit(StandardTypeInfo right) {
            return TypeInfoEquivalence.equivalentBytecodeName(this.left, right);
        }

        @Override
        public Boolean visit(InternalTypeInfo right) {
            return TypeInfoEquivalence.equivalentBytecodeName(this.left, right);
        }

        @Override
        public Boolean visit(SObjectTypeInfo right) {
            return TypeInfoEquivalence.equivalentBytecodeName(this.left, right);
        }

        @Override
        public Boolean visit(GenericTypeInfo right) {
            return TypeInfoEquivalence.equivalentBytecodeName(this.left, right);
        }
    }

    static class InputJavaTypeVisitor
    extends TypeInfoVisitor.Default<Boolean> {
        private final JavaTypeInfo left;

        public InputJavaTypeVisitor(JavaTypeInfo left) {
            this.left = left;
        }

        @Override
        protected Boolean _default(TypeInfo right) {
            return false;
        }

        @Override
        public Boolean visit(JavaTypeInfo right) {
            return TypeInfoEquivalence.equivalentBytecodeName(this.left, right);
        }

        @Override
        public Boolean visit(InternalTypeInfo right) {
            return TypeInfoEquivalence.equivalentBytecodeName(this.left, right);
        }

        @Override
        public Boolean visit(StandardTypeInfo right) {
            return TypeInfoEquivalence.isStandardTypeEquivalentToJavaType(right, this.left);
        }

        @Override
        public Boolean visit(ScalarTypeInfo right) {
            return TypeInfoEquivalence.equivalentBytecodeName(this.left, right);
        }
    }

    static class InputStandardTypeVisitor
    extends TypeInfoVisitor.Default<Boolean> {
        private final StandardTypeInfo left;

        public InputStandardTypeVisitor(StandardTypeInfo left) {
            this.left = left;
        }

        @Override
        protected Boolean _default(TypeInfo right) {
            return false;
        }

        @Override
        public Boolean visit(JavaTypeInfo right) {
            return TypeInfoEquivalence.isStandardTypeEquivalentToJavaType(this.left, right);
        }

        @Override
        public Boolean visit(StandardTypeInfo right) {
            return TypeInfoEquivalence.equivalentBytecodeName(this.left, right);
        }

        @Override
        public Boolean visit(InternalTypeInfo right) {
            return TypeInfoEquivalence.equivalentBytecodeName(this.left, right);
        }
    }

    public static class CalculateEquivalenceInputTypeVisitor
    implements TypeInfoVisitor<TypeInfoVisitor<Boolean>> {
        private static final CalculateEquivalenceInputTypeVisitor INSTANCE = new CalculateEquivalenceInputTypeVisitor();

        private CalculateEquivalenceInputTypeVisitor() {
        }

        public static CalculateEquivalenceInputTypeVisitor get() {
            return INSTANCE;
        }

        @Override
        public TypeInfoVisitor<Boolean> visit(StandardTypeInfo left) {
            return new InputStandardTypeVisitor(left);
        }

        @Override
        public TypeInfoVisitor<Boolean> visit(ScalarTypeInfo left) {
            return new InputScalarTypeVisitor(left);
        }

        @Override
        public TypeInfoVisitor<Boolean> visit(ModifierOrAnnotationTypeInfo left) {
            return new ApexNameEquivalence(left);
        }

        @Override
        public TypeInfoVisitor<Boolean> visit(GenericTypeInfo left) {
            return new InputGenericTypeVisitor(left);
        }

        @Override
        public TypeInfoVisitor<Boolean> visit(InternalTypeInfo left) {
            return new InputInternalTypeVisitor(left);
        }

        @Override
        public TypeInfoVisitor<Boolean> visit(ArgumentTypeInfo left) {
            return new ApexNameEquivalence(left);
        }

        @Override
        public TypeInfoVisitor<Boolean> visit(JavaTypeInfo left) {
            return new InputJavaTypeVisitor(left);
        }

        @Override
        public TypeInfoVisitor<Boolean> visit(SObjectTypeInfo left) {
            return new InputSObjectTypeVisitor(left);
        }

        @Override
        public TypeInfoVisitor<Boolean> visit(VfComponentTypeInfo left) {
            return new BytecodeNameEquivalence(left);
        }

        @Override
        public TypeInfoVisitor<Boolean> visit(FlowInterviewTypeInfo left) {
            return new BytecodeNameEquivalence(left);
        }
    }
}

