/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.common.iterable.LessStrings;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;

class SymbolInfoSerializer {
    private static final Function<Parameter, String> TO_PARAM_STRING = param -> param.getType().toString();

    SymbolInfoSerializer() {
    }

    public static String serialize(TypeInfo type) {
        return "ApexName: " + type.getApexName() + "\n" + "Namespace: " + type.getNamespace().toString() + "\n" + SymbolInfoSerializer.serialize(type.parents()) + SymbolInfoSerializer.serialize(type.methods()) + SymbolInfoSerializer.serialize(type.fields());
    }

    private static String serialize(ParentTable parents) {
        StringBuilder builder = new StringBuilder();
        builder.append("SuperType: ").append(parents.superType());
        builder.append("\n");
        for (TypeInfo iface : parents.allInterfaces()) {
            builder.append("Interface: ").append(iface.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    private static String serialize(FieldTable fields) {
        ArrayList<String> fieldsStrings = new ArrayList<String>();
        for (FieldInfo field : fields.all()) {
            fieldsStrings.add("Field: " + SymbolInfoSerializer.serialize(field));
        }
        Collections.sort(fieldsStrings);
        return fieldsStrings.stream().collect(Collectors.joining("\n")) + "\n";
    }

    private static String serialize(FieldInfo field) {
        return SymbolInfoSerializer.serialize(field.getModifiers()) + field.getType() + " " + field.getName();
    }

    private static String serialize(MethodTable methods) {
        ArrayList<String> methodsStrings = new ArrayList<String>();
        for (MethodInfo method : methods.all()) {
            methodsStrings.add("Method: " + SymbolInfoSerializer.serialize(method));
        }
        Collections.sort(methodsStrings);
        return LessStrings.toString(methodsStrings, new StringJoiner("\n")) + "\n";
    }

    private static String serialize(MethodInfo method) {
        return SymbolInfoSerializer.serialize(method.getModifiers()) + method.getReturnType().toString() + " " + method.getName() + SymbolInfoSerializer.serialize(method.getParameters());
    }

    private static String serialize(List<Parameter> parameters) {
        return parameters.stream().map(TO_PARAM_STRING).collect(Collectors.joining(", ", "(", ")"));
    }

    private static String serialize(ModifierGroup modifiers) {
        StringBuilder builder = new StringBuilder();
        HashSet<String> mods = new HashSet<String>();
        for (ModifierOrAnnotationTypeInfo mod : modifiers.all()) {
            mods.add(mod.toString());
        }
        if (mods.contains("global")) {
            builder.append("global ");
            mods.remove("global");
        }
        if (mods.contains("public")) {
            builder.append("public ");
            mods.remove("public");
        }
        if (mods.contains("protected")) {
            builder.append("protected ");
            mods.remove("protected");
        }
        if (mods.contains("private")) {
            builder.append("private ");
            mods.remove("private");
        }
        if (mods.contains("static")) {
            builder.append("static ");
            mods.remove("static");
        }
        if (mods.contains("testMethod")) {
            builder.append("testMethod ");
            mods.remove("testMethod");
        }
        if (mods.contains("virtual")) {
            builder.append("virtual ");
            mods.remove("virtual");
        }
        return !mods.isEmpty() ? builder.toString() + ((Object)mods).toString() : builder.toString();
    }
}

