/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.ast.modifier.rule.AnnotationRuleGroup;
import apex.jorje.semantic.common.iterable.CaseInsensitiveMap;
import apex.jorje.semantic.symbol.type.AbstractTypeInfo;
import apex.jorje.semantic.symbol.type.AnnotationProperty;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.visitor.ModifierOrAnnotationVisitor;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StandardAnnotationTypeInfo
extends AbstractTypeInfo
implements ModifierOrAnnotationTypeInfo {
    private final Map<String, AnnotationProperty> properties;
    private final Supplier<AnnotationRuleGroup> ruleGroup;
    private final boolean bytecodeVisible;

    private StandardAnnotationTypeInfo(Builder builder) {
        super(builder);
        this.properties = builder.properties;
        this.ruleGroup = builder.ruleGroup;
        this.bytecodeVisible = builder.bytecodeVisible;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T> T accept(ModifierOrAnnotationVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Map<String, AnnotationProperty> getProperties() {
        return this.properties;
    }

    @Override
    public AnnotationRuleGroup getRuleGroup() {
        return this.ruleGroup.get();
    }

    @Override
    public boolean isBytecodeVisible() {
        return this.bytecodeVisible;
    }

    @Override
    public <T> T accept(TypeInfoVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static class Builder
    extends AbstractTypeInfo.Builder<Builder, StandardAnnotationTypeInfo> {
        private Map<String, AnnotationProperty> properties = Collections.emptyMap();
        private Supplier<AnnotationRuleGroup> ruleGroup;
        private boolean bytecodeVisible = true;

        private Builder() {
        }

        @Override
        public StandardAnnotationTypeInfo build() {
            this.setBytecodeName(MoreObjects.firstNonNull(this.getBytecodeName(), this.getApexName()));
            this.setBasicType(BasicType.ANNOTATION);
            this.setUnitType(UnitType.ANNOTATION);
            this.setResolvedDefaults();
            return new StandardAnnotationTypeInfo(this);
        }

        public Builder setProperties(AnnotationProperty ... properties) {
            return this.setProperties(Arrays.asList(properties));
        }

        public Builder setProperties(List<AnnotationProperty> properties) {
            CaseInsensitiveMap.Builder<AnnotationProperty> builder = CaseInsensitiveMap.builder();
            for (AnnotationProperty property : properties) {
                builder.put(property.getName(), property);
            }
            this.properties = builder.build();
            return this;
        }

        public Builder setRuleGroup(Supplier<AnnotationRuleGroup> ruleGroup) {
            this.ruleGroup = Suppliers.memoize(ruleGroup);
            return this;
        }

        public Builder setRuleGroup(AnnotationRuleGroup ruleGroup) {
            return this.setRuleGroup(Suppliers.ofInstance(ruleGroup));
        }

        public Builder setBytecodeVisible(boolean bytecodeVisible) {
            this.bytecodeVisible = bytecodeVisible;
            return this;
        }
    }
}

