/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodTable;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfo;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfos;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.ReifiedMethodsInitializer;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import apex.jorje.semantic.tester.matchers.IsType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ReifiedMethodsInitializerTest {
    private static final List<TypeInfo> ARGUMENT_TYPE_INFOS = ImmutableList.of(ArgumentTypeInfos.T);
    private static final List<TypeInfo> TYPES = ImmutableList.of(TypeInfos.INTEGER);
    private MethodTable methods;
    private GenericTypeInfo nonGenericType;
    private GenericTypeInfo genericType;
    private ReifiedMethodsInitializer initializer;

    @BeforeMethod
    public void setUp() {
        this.methods = new StandardMethodTable();
        this.nonGenericType = ((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)GenericTypeInfo.builder().setApexBytecodeName("foo")).setTypeArguments(ARGUMENT_TYPE_INFOS).setMethods(this.methods)).buildResolved();
        this.genericType = GenericTypeInfo.builder().setUnreifiedType(this.nonGenericType).setTypeArguments(TYPES).buildResolved();
        this.initializer = new ReifiedMethodsInitializer();
    }

    private void assertClonedMethod(MethodInfo newMethod, MethodInfo originalMethod, TypeInfo returnType, TypeInfo ... parameterTypes) {
        MatcherAssert.assertThat((Object)newMethod.getName(), (Matcher)Matchers.is((Object)originalMethod.getName()));
        MatcherAssert.assertThat((Object)((Object)newMethod.getGenerated()), (Matcher)Matchers.is((Object)((Object)originalMethod.getGenerated())));
        MatcherAssert.assertThat((Object)newMethod.getModifiers(), (Matcher)Matchers.is((Object)originalMethod.getModifiers()));
        MatcherAssert.assertThat((Object)newMethod.isConstructor(), (Matcher)Matchers.is((Object)originalMethod.isConstructor()));
        MatcherAssert.assertThat((Object)newMethod.getName(), (Matcher)Matchers.is((Object)originalMethod.getName()));
        MatcherAssert.assertThat((Object)newMethod.getCanonicalName(), (Matcher)Matchers.is((Object)originalMethod.getCanonicalName()));
        MatcherAssert.assertThat((Object)newMethod.getMethodInterface(), (Matcher)Matchers.is((Object)originalMethod));
        MatcherAssert.assertThat((Object)newMethod.getDefiningType(), IsType.isType(this.genericType));
        MatcherAssert.assertThat((Object)newMethod.getReturnType(), IsType.isType(returnType));
        MatcherAssert.assertThat(newMethod.getParameterTypes(), (Matcher)Matchers.is(Arrays.asList(parameterTypes)));
    }

    @Test
    public void testReturnTypeConverted() {
        MethodInfo originalMethod = StandardMethodInfo.builder().setName("foo").setDefiningType(this.nonGenericType).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).setReturnType(ArgumentTypeInfos.T).build();
        this.methods.addDuplicatesAllowed(originalMethod);
        Collection<MethodInfo> methods = this.initializer.get(this.genericType).all();
        MatcherAssert.assertThat(methods, (Matcher)Matchers.hasSize((int)1));
        this.assertClonedMethod(Iterables.getOnlyElement(methods), originalMethod, TypeInfos.INTEGER, new TypeInfo[0]);
    }

    @Test
    public void testParameterTypesConverted() {
        MethodInfo originalMethod = StandardMethodInfo.builder().setName("foo").setDefiningType(this.nonGenericType).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).setReturnType(TypeInfos.VOID).setNamedParameterTypes(TypeInfos.BOOLEAN, ArgumentTypeInfos.T).build();
        this.methods.addDuplicatesAllowed(originalMethod);
        Collection<MethodInfo> methods = this.initializer.get(this.genericType).all();
        MatcherAssert.assertThat(methods, (Matcher)Matchers.hasSize((int)1));
        this.assertClonedMethod(Iterables.getOnlyElement(methods), originalMethod, TypeInfos.VOID, TypeInfos.BOOLEAN, TypeInfos.INTEGER);
    }

    @Test
    public void testGenericMethodCloning() {
        GenericTypeInfo intSet = GenericTypeInfoFactory.createSet(TypeInfos.INTEGER);
        MethodTable intMethods = intSet.methods();
        GenericTypeInfo stringSet = GenericTypeInfoFactory.createSet(TypeInfos.STRING);
        MethodTable stringMethods = stringSet.methods();
        MatcherAssert.assertThat((Object)intMethods.get(SignatureFactory.create("clone", intSet)), (Matcher)Matchers.not((Object)stringMethods.get(SignatureFactory.create("clone", stringSet))));
    }

    @Test
    public void testMultiLevelTypeParameterResolution() {
        GenericTypeInfo innerSet = GenericTypeInfoFactory.createSet(TypeInfos.STRING);
        GenericTypeInfo outerSet = GenericTypeInfoFactory.createSet(innerSet);
        MatcherAssert.assertThat((Object)outerSet.methods().get(SignatureFactory.create("clone", outerSet)).getReturnType(), IsType.isType(outerSet));
    }

    @Test
    public void testMultiLevelTypeParameterResolution3() {
        ArgumentTypeInfo paramTypePlaceholder = ArgumentTypeInfo.create("P");
        ArgumentTypeInfo returnTypePlaceholder = ArgumentTypeInfo.create("R");
        GenericTypeInfo innermostType = ((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)GenericTypeInfo.builder().setApexBytecodeName("Foo")).setTypeArguments(paramTypePlaceholder, returnTypePlaceholder).setMethods(this.methods)).setModifiers(ModifierGroups.GLOBAL)).buildResolved();
        innermostType.methods().addNoDuplicatesAllowed(StandardMethodInfo.builder().setDefiningType(innermostType).setName("m").setNamedParameterTypes(paramTypePlaceholder).setReturnType(returnTypePlaceholder).setGenerated(Generated.USER).setModifiers(ModifierGroups.GLOBAL).build());
        GenericTypeInfo middleType = GenericTypeInfo.builder().setUnreifiedType(innermostType).setTypeArguments(ArgumentTypeInfos.K, TypeInfos.INTEGER).buildResolved();
        GenericTypeInfo outermostType = GenericTypeInfo.builder().setUnreifiedType(middleType).setTypeArguments(TypeInfos.STRING, TypeInfos.INTEGER).buildResolved();
        MatcherAssert.assertThat(outermostType.methods().all(), (Matcher)Matchers.iterableWithSize((int)1));
        MatcherAssert.assertThat((Object)outermostType.methods().get(SignatureFactory.create("m", (TypeInfo)TypeInfos.INTEGER, TypeInfos.STRING)), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat(middleType.methods().all(), (Matcher)Matchers.iterableWithSize((int)1));
        MatcherAssert.assertThat((Object)middleType.methods().get(SignatureFactory.create("m", (TypeInfo)TypeInfos.INTEGER, ArgumentTypeInfos.K)), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @Test
    public void testClonedWithUnresolvedType() {
        GenericTypeInfoFactory.createList(UnresolvedTypeInfoFactory.create("foo")).methods();
    }
}

