/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ListIteratorInfoTest
extends ValidationTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"ListIterator i;", I18nSupport.getLabel("invalid.unresolved.type", "ListIterator")}, {"System.ListIterator i;", I18nSupport.getLabel("invalid.unresolved.type", "System.ListIterator")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.ANONYMOUS);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"List<Integer> i; i.iterator().next();"}, {"List<Integer> i; i.iterator().hasNext();"}, {"Set<Integer> i; i.iterator().next();"}, {"Set<Integer> i; i.iterator().hasNext();"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.setParserType(ParserWrapper.Type.ANONYMOUS);
        this.tester.assertSuccess(code);
    }
}

