/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class LabelTypeInfoTest
extends ValidationTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"Label l;", I18nSupport.getLabel("type.not.visible", "System.Label")}, {"System.Label l;", I18nSupport.getLabel("type.not.visible", "System.Label")}, {"Label.ns l;", I18nSupport.getLabel("type.not.visible", "System.Label")}, {"System.Label.ns l;", I18nSupport.getLabel("type.not.visible", "System.Label")}, {"new Label();", I18nSupport.getLabel("type.not.visible", "System.Label")}, {"String s = System.Label.foo;", I18nSupport.getLabel("external.string.does.not.exist", "foo")}, {"String s = System.Label.foo.bar;", I18nSupport.getLabel("external.string.does.not.exist", "bar")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.ANONYMOUS);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"String s = Label.foo;"}, {"String s = Label.ns.foo;"}, {"String s = System.Label.foo;"}, {"String s = System.Label.foo.replace('a','b');"}, {"String s = System.Label.ns.foo;"}, {"String s = System.Label.ns.foo.replace('a','b');"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.setParserType(ParserWrapper.Type.ANONYMOUS);
        this.tester.addTestLabelField("", "foo");
        this.tester.addTestLabelField("ns", "foo");
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] softBind() {
        return new Object[][]{{"String s = Label.foo;"}, {"String s = Label.foo.foo;"}, {"String s = System.Label.foo;"}, {"String s = System.Label.foo.replace('a','b');"}, {"String s = System.Label.foo.foo;"}, {"String s = System.Label.foo.bar;"}, {"String s = System.Label.foo.foo.replace('a','b');"}};
    }

    @Test(dataProvider="softBind")
    public void testSoftBind(String code) {
        this.tester.setParserType(ParserWrapper.Type.ANONYMOUS);
        this.tester.addTestLabelField("", "foo");
        this.tester.addTestLabelField("foo", "foo");
        this.tester.addTestLabelField("foo", "bar");
        this.tester.assertSuccess(code);
    }
}

