/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.type.JavaTypeInfo;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.JavaTypeInfoUtil;
import apex.jorje.semantic.tester.matchers.IsType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class JavaTypeInfoTest {
    @Spy
    private JavaTypeInfoUtil util;

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testVoid() {
        MatcherAssert.assertThat((Object)this.util.createJava((Class<?>)Void.TYPE), IsType.isType(TypeInfos.VOID));
        MatcherAssert.assertThat((Object)this.util.createJava((Class<?>)Void.class), IsType.isType(TypeInfos.VOID));
        MatcherAssert.assertThat((Object)this.util.fromJavaType(Void.TYPE, JavaTypeInfoUtil.TypeUsage.AS_PARAMETER), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)this.util.fromJavaType(Void.class, JavaTypeInfoUtil.TypeUsage.AS_PARAMETER), IsType.isType(TypeInfos.VOID));
    }

    @Test
    public void testCreate() {
        Mockito.when((Object)this.util.lookupClass("apex.bytecodeinterpreter.ExceptionProvider$CallingFrameProvider")).thenReturn(FrameProvider.class);
        Mockito.when((Object)this.util.lookupClass("apex.bytecodeinterpreter.ExecutionContext")).thenReturn(ExecutionContext.class);
        Mockito.when((Object)this.util.lookupClass("apex.ast.PositionProvider")).thenReturn(Position.class);
        Mockito.when((Object)this.util.lookupClass("common.apex.runtime.ApexExecutionContext")).thenReturn(Context.class);
        Mockito.when((Object)this.util.lookupClass("common.apex.runtime.ApexJavaBindingIgnore")).thenReturn(ApexIgnore.class);
        JavaTypeInfo type = JavaTypeInfo.builder().setClass(MyType.class).setUtil(this.util).build();
        MatcherAssert.assertThat((Object)type.methods().get(SignatureFactory.create("ignoredPrivate", TypeInfos.VOID)), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)type.methods().get(SignatureFactory.create("ignoredParametersOne", TypeInfos.VOID)), (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)type.methods().get(SignatureFactory.create("ignoredParametersTwo", TypeInfos.VOID)), (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)type.methods().get(SignatureFactory.create("foo", (TypeInfo)TypeInfos.VOID, ReifiedTypeInfos.STRING_SET)), (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)type.methods().get(SignatureFactory.create("foo", (TypeInfo)TypeInfos.VOID, TypeInfos.STRING)), (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)type.methods().get(SignatureFactory.create("ignoredMethod", TypeInfos.VOID)), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)type.methods().get(SignatureFactory.create("<init>", TypeInfos.VOID)), (Matcher)IsNull.notNullValue());
    }

    @DataProvider
    Object[][] fromApexTypeData() {
        return new Object[][]{{TypeInfos.LIST, List.class}, {TypeInfos.SET, Set.class}, {TypeInfos.MAP, Map.class}, {TypeInfos.STRING, String.class}};
    }

    @Test(dataProvider="fromApexTypeData")
    public void testFromApexType(TypeInfo type, Class<?> clazz) {
        MatcherAssert.assertThat(this.util.fromApexType(type), (Matcher)Matchers.is(clazz));
    }

    private static class FrameProvider {
        private FrameProvider() {
        }
    }

    private static class ExecutionContext {
        private ExecutionContext() {
        }
    }

    private static class Position {
        private Position() {
        }
    }

    private static class Context {
        private Context() {
        }
    }

    public static class MyType {
        @ApexIgnore
        public void ignoredMethod() {
        }

        private void ignoredPrivate() {
        }

        public void ignoredParametersOne(Context ctx, Position p) {
        }

        public void ignoredParametersTwo(ExecutionContext ctx, FrameProvider p) {
        }

        public void foo(String s) {
        }

        public void foo(Set<String> set) {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    private static @interface ApexIgnore {
    }
}

