/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.symbol.type.AbstractTypeInfo;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.tester.matchers.IsType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class GenericTypeInfoTest {
    @Test
    public void testList() {
        GenericTypeInfo list = GenericTypeInfoFactory.createList(TypeInfos.INTEGER);
        MatcherAssert.assertThat((Object)CollectionTypeInfoUtil.getElementType(list), IsType.isType(TypeInfos.INTEGER));
        MatcherAssert.assertThat((Object)list.getBytecodeName(), (Matcher)Matchers.is((Object)"com/salesforce/api/fast/List$$ljava/lang/Integer$$r"));
        MatcherAssert.assertThat((Object)list.getTypeSignature(), (Matcher)Matchers.is((Object)"Lcom/salesforce/api/fast/List$$ljava/lang/Integer$$r;"));
        MatcherAssert.assertThat((Object)((Object)list.getBasicType()), (Matcher)Matchers.is((Object)((Object)TypeInfos.LIST.getBasicType())));
    }

    @Test
    public void testSet() {
        GenericTypeInfo set = GenericTypeInfoFactory.createSet(TypeInfos.INTEGER);
        MatcherAssert.assertThat((Object)CollectionTypeInfoUtil.getElementType(set), IsType.isType(TypeInfos.INTEGER));
        MatcherAssert.assertThat((Object)((Object)set.getBasicType()), (Matcher)Matchers.is((Object)((Object)BasicType.SET)));
        MatcherAssert.assertThat((Object)set.getBytecodeName(), (Matcher)Matchers.is((Object)"com/salesforce/api/fast/Set$$ljava/lang/Integer$$r"));
        MatcherAssert.assertThat((Object)set.getApexName(), (Matcher)Matchers.is((Object)"Set<Integer>"));
    }

    @Test
    public void testMap() {
        GenericTypeInfo map = GenericTypeInfoFactory.createMap(TypeInfos.INTEGER, TypeInfos.STRING);
        MatcherAssert.assertThat((Object)CollectionTypeInfoUtil.getKeyType(map), IsType.isType(TypeInfos.INTEGER));
        MatcherAssert.assertThat((Object)CollectionTypeInfoUtil.getValueType(map), IsType.isType(TypeInfos.STRING));
        MatcherAssert.assertThat((Object)map.getBytecodeName(), (Matcher)Matchers.is((Object)"com/salesforce/api/fast/Map$$ljava/lang/Integer$$cjava/lang/String$$r"));
        MatcherAssert.assertThat((Object)map.getTypeSignature(), (Matcher)Matchers.is((Object)"Lcom/salesforce/api/fast/Map$$ljava/lang/Integer$$cjava/lang/String$$r;"));
        MatcherAssert.assertThat((Object)((Object)map.getBasicType()), (Matcher)Matchers.is((Object)((Object)TypeInfos.MAP.getBasicType())));
    }

    @Test
    public void testEquals() {
        GenericTypeInfo map1 = GenericTypeInfo.builder().setUnreifiedType(TypeInfos.MAP).setTypeArguments(TypeInfos.INTEGER, TypeInfos.STRING).build();
        GenericTypeInfo map2 = GenericTypeInfo.builder().setUnreifiedType(TypeInfos.MAP).setTypeArguments(TypeInfos.INTEGER, TypeInfos.STRING).build();
        GenericTypeInfo invalidArguments1 = GenericTypeInfo.builder().setUnreifiedType(TypeInfos.MAP).setTypeArguments(TypeInfos.STRING).build();
        GenericTypeInfo invalidArguments2 = GenericTypeInfo.builder().setUnreifiedType(TypeInfos.MAP).setTypeArguments(TypeInfos.STRING, TypeInfos.STRING).build();
        GenericTypeInfo invalidArguments3 = GenericTypeInfo.builder().setUnreifiedType(TypeInfos.MAP).setTypeArguments(TypeInfos.STRING, TypeInfos.STRING, TypeInfos.STRING).build();
        GenericTypeInfo invalidType = GenericTypeInfo.builder().setUnreifiedType(TypeInfos.LIST).setTypeArguments(TypeInfos.INTEGER, TypeInfos.STRING).build();
        MatcherAssert.assertThat((Object)TypeInfoEquivalence.isEquivalent(map1, map2), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)TypeInfoEquivalence.isEquivalent(map1, invalidArguments1), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)TypeInfoEquivalence.isEquivalent(map1, invalidArguments2), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)TypeInfoEquivalence.isEquivalent(map1, invalidArguments3), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)TypeInfoEquivalence.isEquivalent(map1, invalidType), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testDepth() {
        AbstractTypeInfo type = TypeInfos.INTEGER;
        for (int i = 0; i < GenericTypeInfo.MAX_SIZE; ++i) {
            type = GenericTypeInfoFactory.createList(type);
            MatcherAssert.assertThat((String)("Type should be resolved: " + type), (Object)type.isResolved(), (Matcher)Matchers.is((Object)true));
        }
        type = GenericTypeInfoFactory.createList(type);
        MatcherAssert.assertThat((String)("Type should NOT be resolved: " + type), (Object)type.isResolved(), (Matcher)Matchers.is((Object)false));
    }
}

