/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.symbol.type.ArgumentTypeInfos;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import apex.jorje.semantic.tester.matchers.IsType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.MatcherAssert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class GenericTypeInfoFactoryTest {
    private static final TypeInfo FIVE_DEEP_LIST = GenericTypeInfoFactory.createList(GenericTypeInfoFactory.createList(GenericTypeInfoFactory.createList(GenericTypeInfoFactory.createList(GenericTypeInfoFactory.createList(TypeInfos.INTEGER)))));
    private static final TypeInfo UNRESOLVED_FOO = UnresolvedTypeInfoFactory.create("foo");
    private static final TypeInfo FOO_CLASS_TYPE = ((GenericTypeInfo.Builder)GenericTypeInfo.builder().setApexBytecodeName("foo")).setTypeArguments(ArgumentTypeInfos.T).buildResolved();

    @SafeVarargs
    private final <T> List<T> asList(T ... items) {
        return items.length == 1 ? Collections.singletonList(items[0]) : Arrays.asList(items);
    }

    @DataProvider
    Object[][] createData() {
        return new Object[][]{{UnresolvedTypeInfoFactory.get(), this.asList(TypeInfos.INTEGER), UnresolvedTypeInfoFactory.create(UnresolvedTypeInfoFactory.get(), TypeInfos.INTEGER)}, {FOO_CLASS_TYPE, this.asList(UNRESOLVED_FOO), UnresolvedTypeInfoFactory.create(FOO_CLASS_TYPE, UNRESOLVED_FOO)}, {TypeInfos.INTEGER, this.asList(TypeInfos.STRING), UnresolvedTypeInfoFactory.create((TypeInfo)TypeInfos.INTEGER, TypeInfos.STRING)}, {FOO_CLASS_TYPE, this.asList(TypeInfos.INTEGER, TypeInfos.STRING), UnresolvedTypeInfoFactory.create(FOO_CLASS_TYPE, TypeInfos.INTEGER, TypeInfos.STRING)}, {FOO_CLASS_TYPE, this.asList(FIVE_DEEP_LIST), UnresolvedTypeInfoFactory.create(FOO_CLASS_TYPE, FIVE_DEEP_LIST)}};
    }

    @Test(dataProvider="createData")
    public void testCreate(TypeInfo type, List<TypeInfo> typeArguments, TypeInfo expected) {
        GenericTypeInfo actual = GenericTypeInfoFactory.create(type, typeArguments);
        MatcherAssert.assertThat((Object)actual, IsType.isType(expected));
    }

    @Test(expectedExceptions={AssertionError.class}, expectedExceptionsMessageRegExp="parameters cannot be null")
    public void testNullType() {
        GenericTypeInfoFactory.create(null, new TypeInfo[0]);
    }

    @Test(expectedExceptions={AssertionError.class}, expectedExceptionsMessageRegExp="argument types must be non empty")
    public void testNoTypeArguments() {
        GenericTypeInfoFactory.create((TypeInfo)TypeInfos.STRING, new TypeInfo[0]);
    }

    @Test(expectedExceptions={AssertionError.class}, expectedExceptionsMessageRegExp="parameters cannot be null")
    public void testNullTypeArguments() {
        List<TypeInfo> nullList = null;
        GenericTypeInfoFactory.create((TypeInfo)TypeInfos.STRING, nullList);
    }
}

