/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.common.initializer.Initializers;
import apex.jorje.semantic.symbol.type.AbstractTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoDepthCalculator;
import apex.jorje.semantic.symbol.type.ReifiedFieldsInitializer;
import apex.jorje.semantic.symbol.type.ReifiedMethodsInitializer;
import apex.jorje.semantic.symbol.type.ReifiedParentsInitializer;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;

public class GenericTypeInfo
extends AbstractTypeInfo {
    public static final Integer MAX_SIZE = 5;
    private final List<TypeInfo> typeArguments;
    private final TypeInfo unreifiedType;
    private final TypeInfo rootUnreifiedType;

    private GenericTypeInfo(Builder builder) {
        super(builder);
        this.typeArguments = builder.typeArguments;
        this.unreifiedType = builder.unreifiedType;
        this.rootUnreifiedType = this.unreifiedType == null ? this : GenericTypeInfoUtil.getRootType(this.unreifiedType);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public List<TypeInfo> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public String toString() {
        return this.getApexName();
    }

    public TypeInfo getRootUnreifiedType() {
        return this.rootUnreifiedType;
    }

    public TypeInfo getUnreifiedType() {
        return this.unreifiedType;
    }

    public boolean acceptArguments(TypeInfoVisitor<Boolean> visitor) {
        for (TypeInfo type : this.getTypeArguments()) {
            if (type.accept(visitor).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> T accept(TypeInfoVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static class Builder
    extends AbstractTypeInfo.Builder<Builder, GenericTypeInfo> {
        private TypeInfo unreifiedType;
        private List<TypeInfo> typeArguments = Collections.emptyList();

        private Builder() {
        }

        public Builder setUnreifiedType(TypeInfo unreifiedType) {
            this.unreifiedType = unreifiedType;
            return this;
        }

        public Builder setTypeArguments(TypeInfo ... typeArguments) {
            return this.setTypeArguments(ImmutableList.copyOf(typeArguments));
        }

        public Builder setTypeArguments(List<TypeInfo> typeArguments) {
            this.typeArguments = Collections.unmodifiableList(typeArguments);
            return this;
        }

        public GenericTypeInfo buildUnresolved() {
            if (this.unreifiedType != null) {
                this.setApexBytecodeName();
                this.cloneUnreifiedType();
            } else {
                this.setResolvedDefaults();
            }
            this.setResolved(false);
            return new GenericTypeInfo(this);
        }

        @Override
        public GenericTypeInfo build() {
            assert (this.getApexName() != null || this.unreifiedType != null) : "you must set either apexName or unreifiedType";
            assert (!this.typeArguments.isEmpty()) : "generic types must have at least one type parameter";
            this.setApexBytecodeName();
            if (this.unreifiedType != null && !CollectionTypeInfoUtil.isMapOrCollection(this.unreifiedType)) {
                this.setBytecodeMethodName(this.unreifiedType.getBytecodeMethodName());
            }
            if (this.unreifiedType != null) {
                this.cloneUnreifiedType();
                boolean isResolved = this.typeArguments.size() == this.unreifiedType.getTypeArguments().size() && GenericTypeInfoDepthCalculator.calculate(this.typeArguments) <= MAX_SIZE;
                this.setResolved(isResolved);
            }
            return new GenericTypeInfo(this);
        }

        @Override
        public GenericTypeInfo buildResolved() {
            assert (this.getApexName() != null || this.unreifiedType != null) : "you must set either apexName or unreifiedType";
            assert (!this.typeArguments.isEmpty()) : "generic types must have at least one type parameter";
            assert (this.unreifiedType == null || this.typeArguments.size() == this.unreifiedType.getTypeArguments().size());
            this.setApexBytecodeName();
            if (this.unreifiedType != null) {
                this.cloneUnreifiedType();
                assert (GenericTypeInfoDepthCalculator.calculate(this.typeArguments) <= MAX_SIZE) : "max depth hit";
            } else {
                this.setResolvedDefaults();
            }
            return new GenericTypeInfo(this);
        }

        private void setApexBytecodeName() {
            Builder type = this.unreifiedType == null ? this : GenericTypeInfoUtil.getRootType(this.unreifiedType);
            this.setApexName(TypeNameUtil.createApexName(type, this.typeArguments));
            this.setBytecodeName(TypeNameUtil.createBytecodeName(type, this.typeArguments));
        }

        private void cloneUnreifiedType() {
            this.setUnitType(this.unreifiedType.getUnitType());
            this.setBasicType(this.unreifiedType.getBasicType());
            this.setNamespace(this.unreifiedType.getNamespace());
            this.setModifiers(this.unreifiedType.getModifiers());
            this.setEnclosingType(this.unreifiedType.getEnclosingType());
            this.setFields(Initializers.memoize(new ReifiedFieldsInitializer()));
            this.setParents(Initializers.memoize(new ReifiedParentsInitializer()));
            this.setMethods(Initializers.memoize(new ReifiedMethodsInitializer()));
        }
    }
}

