/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class EmitSignatureOverrideTest {
    @DataProvider
    Object[][] collectionTypesData() {
        return new Object[][]{{TypeInfos.LIST}, {TypeInfos.SET}, {TypeInfos.MAP}};
    }

    @Test(dataProvider="collectionTypesData")
    public void testCollectionTypes(TypeInfo type) {
        for (MethodInfo method : type.methods().all()) {
            MatcherAssert.assertThat((Object)this.containsArgumentTypeInfo(method.getEmitSignature().getReturnType()), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)this.containsArgumentTypeInfo(method.getEmitSignature().getParameterTypes()), (Matcher)Matchers.is((Object)false));
        }
    }

    private boolean containsArgumentTypeInfo(List<TypeInfo> types) {
        for (TypeInfo type : types) {
            if (!this.containsArgumentTypeInfo(type)) continue;
            return true;
        }
        return false;
    }

    private boolean containsArgumentTypeInfo(TypeInfo type) {
        return type.accept(new TypeInfoVisitor.Default<Boolean>(){

            @Override
            protected Boolean _default(TypeInfo type) {
                return false;
            }

            @Override
            public Boolean visit(GenericTypeInfo type) {
                return TypeInfoUtil.containsPlaceholders(type);
            }

            @Override
            public Boolean visit(ArgumentTypeInfo type) {
                return false;
            }
        });
    }
}

