/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.symbol.type.BasicType;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class BasicTypeTest {
    private static final Set<BasicType> INTEGER_OR_LONG = ImmutableSet.of(BasicType.INTEGER, BasicType.LONG);
    private static final Set<BasicType> NUMBER = ImmutableSet.of(BasicType.INTEGER, BasicType.LONG, BasicType.DOUBLE, BasicType.DECIMAL);
    private static final Set<BasicType> COLLECTION = ImmutableSet.of(BasicType.SET, BasicType.LIST, BasicType.MAP);
    private static final Set<BasicType> DATE_OR_TIME = ImmutableSet.of(BasicType.DATE, BasicType.DATE_TIME, BasicType.TIME);
    private static final Set<BasicType> ALLOWS_INEQUALITY = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(NUMBER)).addAll(DATE_OR_TIME)).add((Object[])new BasicType[]{BasicType.STRING, BasicType.ID})).build();
    private static final Set<BasicType> IS_APEX_OBJECT = ImmutableSet.of(BasicType.APEX_OBJECT, BasicType.AURA_COMPONENT, BasicType.VF_COMPONENT, BasicType.FLOW_INTERVIEW);
    private static final Set<BasicType> REFERENCE = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(COLLECTION)).add((Object[])new BasicType[]{BasicType.SOBJECT, BasicType.APEX_OBJECT, BasicType.JAVA, BasicType.AURA_COMPONENT, BasicType.EXCEPTION, BasicType.OBJECT})).build();

    @DataProvider
    Object[][] methodData() {
        return new Object[][]{{"isIntegerOrLong", INTEGER_OR_LONG}, {"isNumber", NUMBER}, {"isDateOrTime", DATE_OR_TIME}, {"allowsInequality", ALLOWS_INEQUALITY}, {"isApexObject", IS_APEX_OBJECT}, {"isReference", REFERENCE}};
    }

    @Test(dataProvider="methodData")
    public void testMethod(String name, Set<BasicType> positive) throws Exception {
        Method method = BasicType.class.getMethod(name, new Class[0]);
        for (BasicType type : BasicType.values()) {
            MatcherAssert.assertThat((Object)method.invoke((Object)type, new Object[0]), (Matcher)Matchers.is((Object)positive.contains((Object)type)));
        }
    }
}

