/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfos;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.ArgumentTypeInfoConverter;
import apex.jorje.semantic.tester.TestConstants;
import apex.jorje.semantic.tester.matchers.IsType;
import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ArgumentTypeInfoConverterTest {
    private static final GenericTypeInfo FOO_OF_T = ((GenericTypeInfo.Builder)GenericTypeInfo.builder().setFileBase(TestConstants.EMPTY_SOURCE, CompilationUnitBuilder.emptyClass((String)"Foo"))).setTypeArguments(ArgumentTypeInfos.T).buildResolved();
    private static final Parameter GENERIC_PARAMETER = Parameter.builder().setDefiningType(TestConstants.BAR).setName("foo").setType(ArgumentTypeInfos.T).build();
    private static final Map<Equivalence.Wrapper<? extends TypeInfo>, TypeInfo> TYPE_TO_TYPE = ImmutableMap.builder().put(ArgumentTypeInfos.T.getEquivalenceWrapper(), TypeInfos.INTEGER).build();
    private static final Parameter CONCRETE_PARAMETER = Parameter.builder().setDefiningType(TestConstants.BAR).setName("bar").setType(TypeInfos.BLOB).build();
    private static final List<Parameter> PARAMETERS = Lists.newArrayList(GENERIC_PARAMETER, CONCRETE_PARAMETER);

    private void assertProperlyConvertedType(Parameter old, Parameter modified, TypeInfo expected) {
        MatcherAssert.assertThat((Object)modified.getName(), (Matcher)Matchers.is((Object)old.getName()));
        MatcherAssert.assertThat((Object)modified.getType(), IsType.isType(expected));
        MatcherAssert.assertThat((Object)modified.getModifierInfo(), (Matcher)Matchers.is((Object)old.getModifierInfo()));
    }

    @DataProvider
    Object[][] getTypeFromMapData() {
        return new Object[][]{{TypeInfos.BLOB, TypeInfos.BLOB}, {ArgumentTypeInfos.T, TypeInfos.INTEGER}, {GenericTypeInfoFactory.createList(ArgumentTypeInfos.T), ReifiedTypeInfos.INTEGER_LIST}};
    }

    @Test(dataProvider="getTypeFromMapData")
    public void testGetTypeFromMap(TypeInfo input, TypeInfo expected) {
        MatcherAssert.assertThat((Object)ArgumentTypeInfoConverter.convertType(TYPE_TO_TYPE, input), IsType.isType(expected));
    }

    @DataProvider
    Object[][] getTypeData() {
        return new Object[][]{{TypeInfos.BLOB, TypeInfos.BLOB}, {ArgumentTypeInfos.T, TypeInfos.OBJECT}, {GenericTypeInfoFactory.createList(ArgumentTypeInfos.T), ReifiedTypeInfos.OBJECT_LIST}};
    }

    @Test(dataProvider="getTypeData")
    public void testGetType(TypeInfo input, TypeInfo expected) {
        MatcherAssert.assertThat((Object)ArgumentTypeInfoConverter.convertType(input), IsType.isType(expected));
    }

    @DataProvider
    Object[][] getListSetMapTypeData() {
        return new Object[][]{{TypeInfos.BLOB, TypeInfos.BLOB}, {GenericTypeInfoFactory.create((TypeInfo)FOO_OF_T, ArgumentTypeInfos.T), FOO_OF_T}, {GenericTypeInfoFactory.createList(ArgumentTypeInfos.T), ReifiedTypeInfos.OBJECT_LIST}};
    }

    @Test(dataProvider="getListSetMapTypeData")
    public void testGetListSetMapType(TypeInfo input, TypeInfo expected) {
        MatcherAssert.assertThat((Object)ArgumentTypeInfoConverter.convertListSetMapType(input), IsType.isType(expected));
    }

    @Test
    public void testConvertTypeToReified() {
        List<Parameter> modifiedParameters = ArgumentTypeInfoConverter.convertParameters(TYPE_TO_TYPE, PARAMETERS);
        MatcherAssert.assertThat(modifiedParameters, (Matcher)Matchers.hasSize((int)2));
        this.assertProperlyConvertedType(GENERIC_PARAMETER, modifiedParameters.get(0), TypeInfos.INTEGER);
        this.assertProperlyConvertedType(CONCRETE_PARAMETER, modifiedParameters.get(1), TypeInfos.BLOB);
    }

    @Test
    public void testConvertTypeToObject() {
        ArrayList<Parameter> parameters = Lists.newArrayList(GENERIC_PARAMETER, CONCRETE_PARAMETER);
        List<Parameter> modifiedParameters = ArgumentTypeInfoConverter.convertParameters(parameters);
        MatcherAssert.assertThat(modifiedParameters, (Matcher)Matchers.hasSize((int)2));
        this.assertProperlyConvertedType(GENERIC_PARAMETER, modifiedParameters.get(0), TypeInfos.OBJECT);
        this.assertProperlyConvertedType(CONCRETE_PARAMETER, modifiedParameters.get(1), TypeInfos.BLOB);
    }
}

