/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.symbol.resolver.StandardSymbolResolver;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolveRule;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.Version;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class TypeNameResolveRuleTest {
    @Test
    public void testNoMinMax() {
        SimpleRule rule = new SimpleRule();
        for (Version version : Version.values()) {
            MatcherAssert.assertThat((Object)rule.isApplicableToVersion(version), (Matcher)Matchers.is((Object)true));
        }
        MatcherAssert.assertThat((Object)rule.isApplicableToVersion(null), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testMinVersion() {
        Version minVersion = Version.V174;
        SimpleRule rule = new SimpleRule(minVersion, null);
        for (Version version : Version.values()) {
            MatcherAssert.assertThat((String)String.format("Version mismatch. minVersion=%s version=%s", new Object[]{minVersion, version}), (Object)rule.isApplicableToVersion(version), (Matcher)Matchers.is((Object)version.isGreaterThanOrEqual(minVersion)));
        }
        MatcherAssert.assertThat((Object)rule.isApplicableToVersion(null), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testMaxVersion() {
        Version maxVersion = Version.V174;
        SimpleRule rule = new SimpleRule(null, maxVersion);
        for (Version version : Version.values()) {
            MatcherAssert.assertThat((String)String.format("Version mismatch. maxVersion=%s version=%s", new Object[]{maxVersion, version}), (Object)rule.isApplicableToVersion(version), (Matcher)Matchers.is((Object)maxVersion.isGreaterThanOrEqual(version)));
        }
        MatcherAssert.assertThat((Object)rule.isApplicableToVersion(null), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testMinMaxVersion() {
        Version minVersion = Version.V174;
        Version maxVersion = Version.V178;
        SimpleRule rule = new SimpleRule(minVersion, maxVersion);
        for (Version version : Version.values()) {
            MatcherAssert.assertThat((String)String.format("Version mismatch. minVersion=%s maxVersion=%s version=%s", new Object[]{minVersion, maxVersion, version}), (Object)rule.isApplicableToVersion(version), (Matcher)Matchers.is((Object)(version.isGreaterThanOrEqual(minVersion) && maxVersion.isGreaterThanOrEqual(version) ? 1 : 0)));
        }
        MatcherAssert.assertThat((Object)rule.isApplicableToVersion(null), (Matcher)Matchers.is((Object)true));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMaxVersionLessThanMinVersion() {
        new SimpleRule(Version.V178, Version.V174);
    }

    @Test
    public void testMaxVersionSameAsMinVersion() {
        SimpleRule rule = new SimpleRule(Version.V174, Version.V174);
        for (Version version : Version.values()) {
            MatcherAssert.assertThat((String)String.format("Version mismatch. V174 version=%s", new Object[]{version}), (Object)rule.isApplicableToVersion(version), (Matcher)Matchers.is((Object)(version == Version.V174 ? 1 : 0)));
        }
    }

    private static class SimpleRule
    extends TypeNameResolveRule {
        SimpleRule() {
        }

        SimpleRule(Version minVersion, Version maxVersion) {
            super(minVersion, maxVersion);
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver impl, TypeInfo referencingType, List<String> typeName) {
            return null;
        }
    }
}

