/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolutionGroup;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class TypeNameResolutionOrder {
    private final List<TypeNameResolutionGroup> groups;

    TypeNameResolutionOrder(TypeNameResolutionGroup ... groups) {
        this.groups = ImmutableList.copyOf(groups);
        for (int i = 0; i < groups.length; ++i) {
            Preconditions.checkNotNull(groups[i]);
            int expected = i + 1;
            Preconditions.checkState(expected == groups[i].getNumParts(), "Incorrect number of parts: " + groups[i] + " has " + groups[i].getNumParts() + " but was provided for " + expected);
        }
    }

    public TypeNameResolutionGroup getRule(int numParts) {
        assert (numParts > 0) : "num of parts is less than 1: " + numParts;
        assert (this.hasRule(numParts)) : "no group for the number of parts: " + numParts;
        return this.groups.get(numParts - 1);
    }

    public boolean hasRule(int numParts) {
        assert (numParts > 0) : "num of parts is less than 1: " + numParts;
        return numParts <= this.groups.size();
    }

    public int size() {
        return this.groups.size();
    }
}

