/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TwoPartSystemNamespaceTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] validDateData() {
        return new Object[][]{{"public class Foo { System.iterator<SObject> it;}"}, {"public class Foo { Date d = System.Date.today();}"}, {"public class Foo { Datetime d = System.Datetime.now();}"}};
    }

    @Test(dataProvider="validDateData")
    public void testValidDateFunctions(String code) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] invalidDateData() {
        return new Object[][]{{"public class Foo { System.Date d;}", I18nSupport.getLabel("invalid.unresolved.type", "System.Date")}, {"public class Foo { System.Datetime d;}", I18nSupport.getLabel("invalid.unresolved.type", "System.Datetime")}};
    }

    @Test(dataProvider="invalidDateData")
    public void testInvalidDateFunctions(String code, String error) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(code, error);
    }
}

