/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.symbol.resolver.rules.ResolveRuleTest;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolveRules;
import apex.jorje.semantic.tester.matchers.IsType;
import com.google.common.collect.Lists;
import org.hamcrest.MatcherAssert;
import org.mockito.Mockito;
import org.testng.annotations.Test;

public class TopLevelUdtInSameNamespaceTest
extends ResolveRuleTest {
    @Test
    public void testNoNamespace() {
        Mockito.when((Object)this.symbols.find(this.referencingType, "foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.TopLevelUdtInSameNamespace.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo")), IsType.isType(this.lookupType));
    }

    @Test
    public void testNamespace() {
        Mockito.when((Object)this.referencingType.getNamespace()).thenReturn((Object)NAMESPACE);
        Mockito.when((Object)this.symbols.find(this.referencingType, "namespace__module/foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.TopLevelUdtInSameNamespace.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo")), IsType.isType(this.lookupType));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testInvalidTypeName() {
        TypeNameResolveRules.TopLevelUdtInSameNamespace.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo", "bar"));
    }
}

