/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.symbol.resolver.rules.ResolveRuleTest;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolveRule;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolveRules;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.matchers.IsType;
import apex.jorje.services.Version;
import com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SystemExceptionTest
extends ResolveRuleTest {
    @Test
    public void testNoException() {
        MatcherAssert.assertThat((Object)TypeNameResolveRules.TwoPartSystemExceptions.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo", "bar")), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)TypeNameResolveRules.TwoPartSystemExceptions.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("system", "bar")), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)TypeNameResolveRules.TwoPartSystemExceptions.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo", "exception")), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testBaseException() {
        MatcherAssert.assertThat((Object)TypeNameResolveRules.TwoPartSystemExceptions.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("system", "exception")), IsType.isType(TypeInfos.EXCEPTION));
    }

    @Test
    public void testSystemException() {
        Mockito.when((Object)this.symbols.find(this.referencingType, "com/salesforce/api/exception/fooexception")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.TwoPartSystemExceptions.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("system", "fooexception")), IsType.isType(this.lookupType));
    }

    @Test
    public void testPost148ListException() {
        Mockito.when((Object)this.symbols.find(this.referencingType, "com/salesforce/api/exception/listexception")).thenReturn((Object)this.lookupType);
        Mockito.when((Object)this.symbols.find(this.referencingType, "com/salesforce/api/exception/arrayexception")).thenReturn((Object)this.referencingType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.ArrayException.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("notexception")), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)TypeNameResolveRules.ArrayException.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("arrayexception")), IsType.isType(this.lookupType));
    }

    @DataProvider
    Object[][] versionData() {
        return new Object[][]{{TypeNameResolveRules.ArrayException.INSTANCE, Version.V146, true}, {TypeNameResolveRules.ArrayException.INSTANCE, Version.V148, true}, {TypeNameResolveRules.TwoPartSystemExceptions.INSTANCE, Version.V146, true}, {TypeNameResolveRules.TwoPartSystemExceptions.INSTANCE, Version.V148, true}};
    }

    @Test(dataProvider="versionData")
    public void testIsApplicable(TypeNameResolveRule rule, Version version, boolean expected) {
        MatcherAssert.assertThat((Object)rule.isApplicableToVersion(version), (Matcher)Matchers.is((Object)expected));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testInvalidTwoPartSystemExceptions() {
        TypeNameResolveRules.NamespaceOuterInner.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo"));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testInvalidPost148ListException() {
        TypeNameResolveRules.NamespaceOuterInner.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo", "bar"));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testInvalidPre146ListException() {
        TypeNameResolveRules.NamespaceOuterInner.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo", "bar"));
    }
}

