/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.symbol.resolver.rules.ResolveRuleTest;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolveRules;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoTables;
import apex.jorje.semantic.tester.matchers.IsType;
import apex.jorje.services.Version;
import com.google.common.collect.Lists;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.Test;

public class NamedScalarOrVoidTest
extends ResolveRuleTest {
    @Test
    public void testMinVersionSet() {
        for (Map.Entry<String, TypeInfo> typeInfoEntry : TypeInfoTables.TYPES_BY_APEX_NAME.entrySet()) {
            Mockito.when((Object)((Object)this.codeUnit.getVersion())).thenReturn((Object)Version.MIN);
            TypeInfo expected = typeInfoEntry.getValue().getBasicType().getMinVersion().isGreaterThan(Version.MIN) ? null : typeInfoEntry.getValue();
            MatcherAssert.assertThat((Object)TypeNameResolveRules.NamedScalarOrVoid.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList(typeInfoEntry.getKey())), (Matcher)Matchers.is((Object)expected));
        }
    }

    @Test
    public void testMaxVersionSet() {
        for (Map.Entry<String, TypeInfo> typeInfoEntry : TypeInfoTables.TYPES_BY_APEX_NAME.entrySet()) {
            Mockito.when((Object)((Object)this.codeUnit.getVersion())).thenReturn((Object)Version.CURRENT);
            MatcherAssert.assertThat((Object)TypeNameResolveRules.NamedScalarOrVoid.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList(typeInfoEntry.getKey())), IsType.isType(typeInfoEntry.getValue()));
        }
    }

    @Test
    public void testTypeDoesNotExist() {
        MatcherAssert.assertThat((Object)TypeNameResolveRules.NamedScalarOrVoid.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foobar")), (Matcher)Matchers.nullValue());
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testInvalidTypeName() {
        TypeNameResolveRules.NamedScalarOrVoid.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo", "bar"));
    }
}

