/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.symbol.resolver.rules.ResolveRuleTest;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolveRules;
import apex.jorje.semantic.tester.matchers.IsType;
import com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.Test;

public class FileBaseSystemNamespaceTest
extends ResolveRuleTest {
    @Test
    public void testNoSystemType() {
        MatcherAssert.assertThat((Object)TypeNameResolveRules.FileBaseSystemNamespace.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo")), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testFileBasedSystemType() {
        Mockito.when((Object)this.symbols.find(this.referencingType, "system/foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.FileBaseSystemNamespace.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo")), IsType.isType(this.lookupType));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testInvalidTypeName() {
        TypeNameResolveRules.FileBaseSystemNamespace.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo", "bar"));
    }
}

