/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.jorje.data.JadtFactory;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.semantic.tester.TestAccessEvaluator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class PermGuardVisibilityTest {
    private static final Namespace REFERENCING_NAMESPACE = Namespaces.create("someReferencingNS");
    private static final String PERM_GUARD_STRING = "OrgPermissions.SomeOrgPerm";
    private static final TypeInfo REFERENCING_TYPE = PermGuardVisibilityTest.createPermGuardedReferencingType(REFERENCING_NAMESPACE);
    private static final TypeInfo TARGET_TYPE = PermGuardVisibilityTest.createPermGuardedTargetType();

    private static TypeInfo createPermGuardedTargetType() {
        return ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("targetType")).setModifiers(ModifierGroup.builder().addAnnotationAndResolve(JadtFactory.annotationWithString(AnnotationTypeInfos.PERM_GUARD.getApexName(), PERM_GUARD_STRING)).addModifiers(ModifierTypeInfos.GLOBAL).build().resolve())).buildResolved();
    }

    private static TypeInfo createPermGuardedReferencingType(Namespace referencingNamespace) {
        return ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("referencingType")).setModifiers(ModifierGroups.PRIVATE)).setNamespace(referencingNamespace)).buildResolved();
    }

    @Test
    public void testTypePermGuardNotVisible() {
        TestAccessEvaluator evaluatorBlocksAllPermGuards = new TestAccessEvaluator();
        MatcherAssert.assertThat((Object)Visibility.isTypeVisible(evaluatorBlocksAllPermGuards, REFERENCING_TYPE, TARGET_TYPE, false), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testTypePermGuardVisible() {
        TestAccessEvaluator evaluatorAllowsOnePermGuard = new TestAccessEvaluator();
        evaluatorAllowsOnePermGuard.allowPermGuard(REFERENCING_NAMESPACE, PERM_GUARD_STRING);
        MatcherAssert.assertThat((Object)Visibility.isTypeVisible(evaluatorAllowsOnePermGuard, REFERENCING_TYPE, TARGET_TYPE, false), (Matcher)Matchers.is((Object)true));
    }
}

