/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.common.initializer.Initializer;
import apex.jorje.semantic.common.initializer.Initializers;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.MethodTableFactory;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.member.variable.StandardFieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardFieldTable;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.semantic.tester.TestAccessEvaluator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class HiddenVisibilityTest
extends ValidationTest {
    private static final TestAccessEvaluator EMPTY_ACCESS_EVALUATOR = new TestAccessEvaluator();
    private static final TypeInfo THIRD_TYPE = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setModifiers(ModifierGroups.GLOBAL)).setApexBytecodeName("ThirdType")).buildResolved();
    private static final TypeInfo SECOND_TYPE = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setModifiers(ModifierGroup.builder().addModifiers(ModifierTypeInfos.HIDDEN, ModifierTypeInfos.PUBLIC).build())).setFields(Initializers.memoize(new Initializer<FieldTable, TypeInfo>(){

        @Override
        public FieldTable get(TypeInfo type) {
            StandardFieldTable fields = new StandardFieldTable();
            fields.add((FieldInfo)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName("fieldThird")).setType(THIRD_TYPE)).setModifiers(ModifierGroups.GLOBAL)).setDefiningType(SECOND_TYPE)).build()).throwIfError();
            return fields.resolve();
        }
    }))).setApexBytecodeName("SecondType")).buildResolved();
    private static final TypeInfo FIRST_TYPE = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setModifiers(ModifierGroups.GLOBAL)).setFields(Initializers.memoize(new Initializer<FieldTable, TypeInfo>(){

        @Override
        public FieldTable get(TypeInfo type) {
            StandardFieldTable fields = new StandardFieldTable();
            fields.add((FieldInfo)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName("fieldSecond")).setType(SECOND_TYPE)).setModifiers(ModifierGroups.GLOBAL)).setDefiningType(FIRST_TYPE)).build()).throwIfError();
            return fields.resolve();
        }
    }))).setApexBytecodeName("FirstType")).buildResolved();
    private static final TypeInfo HIDDEN_TYPE_WITH_ACCESSIBLE_METHOD = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setModifiers(ModifierGroups.GLOBAL_HIDDEN)).setMethods(Initializers.memoize(new Initializer<MethodTable, TypeInfo>(){

        @Override
        public MethodTable get(TypeInfo type) {
            return MethodTableFactory.create(StandardMethodInfo.builder().setModifiers(ModifierGroup.builder().addModifiers(ModifierTypeInfos.STATIC).addModifiers(ModifierTypeInfos.GLOBAL).build()).setName("m").setDefiningType(HIDDEN_TYPE_WITH_ACCESSIBLE_METHOD).setReturnType(HIDDEN_TYPE_WITH_ACCESSIBLE_METHOD).setGenerated(Generated.USER).build());
        }
    }))).setApexBytecodeName("HiddenTypeWithAccessibleMethod")).buildResolved();

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester.getSymbolProvider().addAdditionalTypes(FIRST_TYPE, SECOND_TYPE, THIRD_TYPE, HIDDEN_TYPE_WITH_ACCESSIBLE_METHOD);
    }

    @Test
    public void testHiddenType() {
        MatcherAssert.assertThat((Object)Visibility.isTypeVisible(EMPTY_ACCESS_EVALUATOR, FIRST_TYPE, SECOND_TYPE, false), (Matcher)Matchers.is((Object)false));
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"public class X { { FirstType f; Object o = f.fieldSecond.fieldThird; } }"}, {"public class X { { FirstType f; Object o = f.fieldSecond; } }"}, {"public class X { { HiddenTypeWithAccessibleMethod.m(); } } "}};
    }

    @Test(dataProvider="validData")
    public void testValidData(String source) {
        this.tester.assertSuccess(source);
    }
}

