/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.jorje.data.JadtTester;
import apex.jorje.data.ast.Identifier;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.symbol.member.variable.AbstractFieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardFieldInfo;
import apex.jorje.semantic.symbol.resolver.FieldContext;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfos;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FieldContextTest {
    private static final AbstractFieldInfo FOO = ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(Identifier._Identifier(JadtTester.pos((int)5, (int)0), "foo"))).setDefiningType(InternalTypeInfos.APEX_OBJECT)).setType(TypeInfos.INTEGER)).setModifiers(ModifierGroups.STATEMENT_EXECUTED)).build();
    private static final AbstractFieldInfo BAR = ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(Identifier._Identifier(JadtTester.pos((int)6, (int)0), "bar"))).setDefiningType(InternalTypeInfos.APEX_OBJECT)).setType(TypeInfos.INTEGER)).setModifiers(ModifierGroups.GLOBAL_STATIC)).build();
    private FieldContext context;

    @BeforeMethod
    public void setUp() {
        this.context = new FieldContext();
    }

    @Test
    public void testIsIllegalForwardReferenceNoContext() {
        MatcherAssert.assertThat((Object)this.context.isIllegalForwardReference(FOO), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.context.isIllegalForwardReference(BAR), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testIsIllegalForwardReferenceFooContext() {
        this.context.setDeclaration(FOO);
        MatcherAssert.assertThat((Object)this.context.isIllegalForwardReference(FOO), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.context.isIllegalForwardReference(BAR), (Matcher)Is.is((Object)true));
        this.context.clearDeclaration();
    }

    @Test
    public void testIsIllegalForwardReferenceBarContext() {
        this.context.setDeclaration(BAR);
        MatcherAssert.assertThat((Object)this.context.isIllegalForwardReference(FOO), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.context.isIllegalForwardReference(BAR), (Matcher)Is.is((Object)true));
        this.context.clearDeclaration();
    }
}

