/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.variable.AbstractFieldInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.visibility.LegacyVisibility;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;

@SfdcCalled
public class VariableValidator {
    private final SymbolResolver symbols;
    private final ValidationScope scope;
    private final AstNode node;
    private final Visibility.CheckType checkType;

    public VariableValidator(SymbolResolver symbols, ValidationScope scope, AstNode node, Visibility.CheckType checkType) {
        this.symbols = symbols;
        this.scope = scope;
        this.node = node;
        this.checkType = checkType;
    }

    @SfdcCalled
    public SymbolResolver getSymbols() {
        return this.symbols;
    }

    @SfdcCalled
    public ValidationScope getScope() {
        return this.scope;
    }

    @SfdcCalled
    public AstNode getNode() {
        return this.node;
    }

    public boolean validateVisibility(Variable variable) {
        if (!Visibility.isTypeVisibleInImplicitReference(this.symbols.getAccessEvaluator(), this.node.getDefiningType(), variable.getDefiningType(), this.scope.isTestMethod())) {
            this.scope.getErrors().markInvalid(this.node, I18nSupport.getLabel("type.not.visible", variable.getDefiningType()));
            return false;
        }
        if (!(Visibility.isMemberVisible(this.node.getDefiningType(), variable, this.scope.isTestMethod(), this.checkType) || variable.getMemberType() == Member.Type.PROPERTY && LegacyVisibility.isLegacyVisibleForPropertyWrites(this.node.getDefiningType(), variable))) {
            this.scope.getErrors().markInvalid(this.node, I18nSupport.getLabel("variable.not.visible", variable.getDefiningType() + "." + variable.getName()));
            return false;
        }
        if (!Visibility.isTypeVisibleInImplicitReference(this.symbols.getAccessEvaluator(), this.node.getDefiningType(), variable.getType(), this.scope.isTestMethod())) {
            this.scope.getErrors().markInvalid(this.node, I18nSupport.getLabel("type.not.visible", variable.getType()));
            return false;
        }
        return true;
    }

    public boolean validateContext(AbstractFieldInfo field, VariableVisitor.Context context) {
        if (this.symbols.fields().isIllegalForwardReference(field) && context.previous == IdentifierContext.NONE) {
            this.scope.getErrors().markInvalid(this.node, context.loc, I18nSupport.getLabel("illegal.forward.reference", field.getName()));
            return false;
        }
        if (this.symbols.staticContext().get() && !field.getModifiers().has(ModifierTypeInfos.STATIC) && context.previous == IdentifierContext.NONE) {
            this.scope.getErrors().markInvalid(this.node, context.loc, I18nSupport.getLabel("invalid.non.static.variable.context", field.getName(), field.getDefiningType()));
            return false;
        }
        if (!field.getModifiers().has(ModifierTypeInfos.STATIC) && context.previous == IdentifierContext.STATIC) {
            this.scope.getErrors().markInvalid(this.node, context.loc, I18nSupport.getLabel("invalid.non.static.variable.context", field.getName(), field.getDefiningType()));
            return false;
        }
        if (field.getModifiers().has(ModifierTypeInfos.STATIC) && context.previous != IdentifierContext.STATIC && context.previous != IdentifierContext.NONE) {
            this.scope.getErrors().markInvalid(this.node, context.loc, I18nSupport.getLabel("invalid.static.variable.context", field.getName(), field.getDefiningType()));
            return false;
        }
        return true;
    }

    public boolean validateFinalField(AbstractFieldInfo info, VariableVisitor.Context context) {
        if (!(context.isInitialStore || !info.getModifiers().has(ModifierTypeInfos.FINAL) || this.scope.isOutsideMethod() || this.scope.getMethod().isStaticInitialization() || info.getDefiningType() != this.scope.getMethod().getDefiningType() || this.scope.getMethod().isConstructor() || this.scope.getMethod().isTriggerInvoke())) {
            this.scope.getErrors().markInvalid(this.node, context.loc, I18nSupport.getLabel("invalid.final.field.assignment", info.getName()));
            return false;
        }
        return true;
    }

    public boolean validateFinalProperty(AbstractFieldInfo info, VariableVisitor.Context context) {
        return !this.scope.isOutsideMethod() && (this.scope.getMethod().isPropertyAccessor() || this.scope.getMethod().isTriggerInvoke()) || this.validateFinalField(info, context);
    }

    public void illegalStore(Variable info, VariableVisitor.Context context) {
        this.scope.getErrors().markInvalid(this.node, context.loc, I18nSupport.getLabel("invalid.field.type.store", info.getName(), info.getDefiningType()));
    }

    public void illegalLoad(Variable info, VariableVisitor.Context context) {
        this.scope.getErrors().markInvalid(this.node, context.loc, I18nSupport.getLabel("invalid.field.type.load", info.getName(), info.getDefiningType()));
    }
}

