/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.member.variable.DynamicFieldInfo;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.SObjectListPeelInfo;
import apex.jorje.semantic.symbol.member.variable.StandardFieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardPropertyInfo;
import apex.jorje.semantic.symbol.member.variable.TriggerFieldInfo;
import apex.jorje.semantic.symbol.member.variable.TriggerPropertyInfo;
import apex.jorje.semantic.symbol.member.variable.VariableValidator;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.visibility.Visibility;

public class VariableValidateLoadVisitor
implements VariableVisitor<Boolean> {
    private final VariableValidator validator;

    private VariableValidateLoadVisitor(VariableValidator validator) {
        this.validator = validator;
    }

    public static VariableValidateLoadVisitor create(SymbolResolver symbols, ValidationScope scope, AstNode node) {
        return new VariableValidateLoadVisitor(new VariableValidator(symbols, scope, node, Visibility.CheckType.CALLER_READ));
    }

    @Override
    public Boolean visit(LocalInfo info, VariableVisitor.Context context) {
        return this.validator.validateVisibility(info);
    }

    @Override
    public Boolean visit(StandardFieldInfo info, VariableVisitor.Context context) {
        return this.validator.validateVisibility(info) && this.validator.validateContext(info, context);
    }

    @Override
    public Boolean visit(StandardPropertyInfo info, VariableVisitor.Context context) {
        return this.validator.validateVisibility(info) && this.validator.validateContext(info, context);
    }

    @Override
    public Boolean visit(TriggerFieldInfo info, VariableVisitor.Context context) {
        return this.validator.validateVisibility(info);
    }

    @Override
    public Boolean visit(TriggerPropertyInfo info, VariableVisitor.Context context) {
        return this.validator.validateVisibility(info);
    }

    @Override
    public Boolean visit(SObjectFieldInfo info, VariableVisitor.Context context) {
        return true;
    }

    @Override
    public Boolean visit(SObjectListPeelInfo info, VariableVisitor.Context context) {
        return info.getVariable().accept(this, context);
    }

    @Override
    public Boolean visit(DynamicFieldInfo info, VariableVisitor.Context context) {
        if (info.getLoadEmitter() == null) {
            this.validator.illegalLoad(info, context);
            return false;
        }
        return this.validator.validateVisibility(info) && this.validator.validateContext(info, context);
    }
}

