/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.ListMethods;
import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.bcl.TriggerMethods;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.DynamicFieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.SObjectListPeelInfo;
import apex.jorje.semantic.symbol.member.variable.StandardFieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardPropertyInfo;
import apex.jorje.semantic.symbol.member.variable.TriggerFieldInfo;
import apex.jorje.semantic.symbol.member.variable.TriggerPropertyInfo;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.List;
import shaded.org.objectweb.asm.Label;

public class VariableEmitLoadVisitor
implements VariableVisitor<Void> {
    private final Expression expression;
    private final Emitter emitter;
    private final List<Label> branches;

    public VariableEmitLoadVisitor(Expression expression, Emitter emitter) {
        this.expression = expression;
        this.emitter = emitter;
        this.branches = Lists.newArrayList();
    }

    @Override
    public Void visit(LocalInfo info, VariableVisitor.Context context) {
        this.emitter.emitVar(context.loc, 25, info.getPosition(this.emitter));
        return null;
    }

    @Override
    public Void visit(StandardFieldInfo info, VariableVisitor.Context context) {
        if (info.getModifiers().has(ModifierTypeInfos.STATIC)) {
            this.emitter.emitField(context.loc, 178, info);
        } else {
            if (context.previous == IdentifierContext.NONE) {
                this.emitter.emitVar(context.loc, 25, 0);
            }
            this.emitter.emitField(context.loc, 180, info);
        }
        return null;
    }

    @Override
    public Void visit(StandardPropertyInfo info, VariableVisitor.Context context) {
        if (context.previous == IdentifierContext.NONE && !info.getModifiers().has(ModifierTypeInfos.STATIC)) {
            this.emitter.emitVar(context.loc, 25, 0);
        }
        if (info == this.emitter.emitRawProperty()) {
            FieldInfo fieldInfo = info.getUnderlyingField();
            if (fieldInfo.getModifiers().has(ModifierTypeInfos.STATIC)) {
                this.emitter.emitField(context.loc, 178, fieldInfo);
            } else {
                this.emitter.emitField(context.loc, 180, fieldInfo);
            }
        } else {
            MethodInfo getter = info.getProperty().getGetter();
            MethodInfo proxy = this.emitter.getProxyMethodTable().get(context.loc, this.expression.getDefiningType(), info.getDefiningType(), getter);
            AsmMethod asmMethod = proxy != null ? proxy.getAsmMethod() : getter.getAsmMethod();
            this.emitter.emit(context.loc, asmMethod);
        }
        return null;
    }

    @Override
    public Void visit(TriggerFieldInfo info, VariableVisitor.Context context) {
        this.emitter.emit(Loc._SyntheticLoc(), TriggerMethods.getTriggerInstance());
        this.emitter.emitField(context.loc, 180, info);
        return null;
    }

    @Override
    public Void visit(TriggerPropertyInfo info, VariableVisitor.Context context) {
        if (info == this.emitter.emitRawProperty()) {
            if (info.getModifiers().has(ModifierTypeInfos.STATIC)) {
                this.emitter.emitField(context.loc, 178, info);
            } else {
                if (context.previous == IdentifierContext.NONE) {
                    this.emitter.emit(Loc._SyntheticLoc(), TriggerMethods.getTriggerInstance());
                }
                this.emitter.emitField(context.loc, 180, info);
            }
        } else {
            this.emitter.emit(Loc._SyntheticLoc(), TriggerMethods.getTriggerInstance());
            AsmMethod asmMethod = info.getProperty().getGetter().getAsmMethod();
            this.emitter.emit(context.loc, asmMethod);
        }
        return null;
    }

    @Override
    public Void visit(SObjectFieldInfo info, VariableVisitor.Context context) {
        Label end;
        if (!context.isLast) {
            this.emitter.push(context.loc, info.getBytecodeName());
            this.emitter.emit(context.loc, SObjectTypeInfoUtil.getMethodsForEmit(info.getDefiningType()).getValueMethod());
            if (context.emitLast) {
                this.emitter.emit(context.loc, 89);
                Label branch = new Label();
                this.emitter.emitJump(context.loc, 198, branch);
                this.branches.add(branch);
            }
            return null;
        }
        if (context.isLast && !context.emitLast) {
            this.emitter.push(context.loc, info.getBytecodeName());
            return null;
        }
        SObjectTypeInfo.MethodsForEmit methodsForEmit = SObjectTypeInfoUtil.getMethodsForEmit(MoreObjects.firstNonNull(context.firstSObjectTypeInfo, info.getDefiningType()));
        switch (info.getCategory()) {
            case REGULAR: {
                this.emitter.push(context.loc, info.getBytecodeName());
                this.emitter.emit(context.loc, methodsForEmit.getRegularValueMethod());
                break;
            }
            case FOREIGN_KEY: {
                this.emitter.push(context.loc, info.getBytecodeName());
                this.emitter.emit(context.loc, methodsForEmit.getValueMethod());
                break;
            }
            case AGGREGATE: {
                assert (SObjectTypeInfoUtil.isConcreteSObjectList(info.getType())) : "this should be a concrete sobject list";
                TypeInfo type = CollectionTypeInfoUtil.getElementType(info.getType());
                this.emitter.push(context.loc, info.getName());
                this.emitter.push(context.loc, type.getApexName());
                this.emitter.emit(context.loc, this.expression.getOptions().isListForEachStatement ? methodsForEmit.getAggregateForSelectMethod() : methodsForEmit.getAggregateMethod());
                break;
            }
            default: {
                throw new UnexpectedCodePathException();
            }
        }
        this.branches.forEach(this.emitter::emit);
        if (CollectionTypeInfoUtil.isList(info.getType())) {
            this.emitter.emit(context.loc, 89);
            end = new Label();
            this.emitter.emitJump(context.loc, 199, end);
            this.emitter.emit(context.loc, 87);
            this.emitter.emitType(context.loc, 187, info.getType());
            this.emitter.emit(context.loc, 89);
            AsmMethod constructor = ObjectMethods.constructor(info.getType(), new TypeInfo[0]);
            this.emitter.emit(context.loc, constructor);
            this.emitter.emit(end);
        } else if (info.getType().equals(TypeInfos.BOOLEAN)) {
            this.emitter.emit(context.loc, 89);
            end = new Label();
            this.emitter.emitJump(context.loc, 199, end);
            this.emitter.emit(context.loc, 87);
            this.emitter.push(context.loc, false);
            this.emitter.emitBox(TypeInfos.BOOLEAN);
            this.emitter.emit(end);
        }
        return null;
    }

    @Override
    public Void visit(SObjectListPeelInfo info, VariableVisitor.Context context) {
        this.emitter.push(context.loc, info.getElementType().getBytecodeName());
        this.emitter.emit(context.loc, ListMethods.getFirstSObjectBytecode());
        info.getVariable().accept(this, context);
        return null;
    }

    @Override
    public Void visit(DynamicFieldInfo info, VariableVisitor.Context context) {
        if (info.getLoadEmitter() != null) {
            info.getLoadEmitter().emit(this.emitter, info, context);
        }
        return null;
    }
}

