/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.data.JadtTester;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.member.variable.StandardFieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardFieldTable;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.TestConstants;
import apex.jorje.semantic.tester.TestSymbolResolvers;
import apex.jorje.services.I18nSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class StandardFieldTableTest {
    private static final SymbolResolver SYMBOLS = TestSymbolResolvers.createEmptySymbols();
    private static final FieldInfo INSTANCE = ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(JadtTester.FOO_ID.value)).setDefiningType(InternalTypeInfos.APEX_OBJECT)).setType(TypeInfos.INTEGER)).setModifiers(ModifierGroups.STATEMENT_EXECUTED)).build(SYMBOLS);
    private static final FieldInfo STATIC = ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(JadtTester.FOO_ID.value)).setDefiningType(InternalTypeInfos.APEX_OBJECT)).setType(TypeInfos.INTEGER)).setModifiers(ModifierGroups.GLOBAL_STATIC)).build(SYMBOLS);
    private FieldTable table;

    @BeforeMethod
    public void setUp() throws Exception {
        this.table = new StandardFieldTable();
    }

    @Test
    public void testLookupInstanceVariable() {
        this.table.add(INSTANCE).throwIfError();
        this.table.resolve();
        MatcherAssert.assertThat((Object)this.table.get(SYMBOLS, TestConstants.FOO, JadtTester.FOO_ID.value, false), (Matcher)Matchers.is((Object)INSTANCE));
        MatcherAssert.assertThat((Object)this.table.get(SYMBOLS, TestConstants.FOO, JadtTester.FOO_ID.value, true), (Matcher)Matchers.is((Object)INSTANCE));
    }

    @Test
    public void testCaseInsensitiveLookup() {
        this.table.add(INSTANCE).throwIfError();
        this.table.resolve();
        MatcherAssert.assertThat((Object)this.table.get(SYMBOLS, TestConstants.FOO, "FOO", false), (Matcher)Matchers.is((Object)INSTANCE));
        MatcherAssert.assertThat((Object)this.table.get(SYMBOLS, TestConstants.FOO, "foo", true), (Matcher)Matchers.is((Object)INSTANCE));
    }

    @Test
    public void testDuplicateInstanceVariables() {
        this.table.add(INSTANCE).throwIfError();
        MatcherAssert.assertThat((Object)this.table.add(INSTANCE).getError(), (Matcher)Matchers.is((Object)I18nSupport.getLabel("duplicate.field", "Foo")));
    }

    @Test
    public void testDuplicateStaticInstanceVariables() {
        this.table.add(INSTANCE).throwIfError();
        MatcherAssert.assertThat((Object)this.table.add(STATIC).getError(), (Matcher)Matchers.is((Object)I18nSupport.getLabel("duplicate.field", "Foo")));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testIllegalAddAfterResolve() {
        this.table.add(INSTANCE).throwIfError();
        this.table.resolve();
        this.table.add(STATIC).throwIfError();
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testIllegalGetBeforeResolve() {
        this.table.get(SYMBOLS, TestConstants.FOO, "FOO", false);
    }
}

