/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class SignatureTest {
    private static final String FOO = "FOO";
    private static final String BAR = "BAR";

    @Test
    public void testBuild() {
        MatcherAssert.assertThat((Object)SignatureFactory.create(FOO, (TypeInfo)TypeInfos.OBJECT, TypeInfos.OBJECT).getValue(), (Matcher)Matchers.is((Object)"(Ljava/lang/Object;)Ljava/lang/Object;"));
        MatcherAssert.assertThat((Object)SignatureFactory.create(FOO, TypeInfos.OBJECT).getValue(), (Matcher)Matchers.is((Object)"()Ljava/lang/Object;"));
        MatcherAssert.assertThat((Object)SignatureFactory.create(FOO, (TypeInfo)TypeInfos.VOID, TypeInfos.OBJECT).getValue(), (Matcher)Matchers.is((Object)"(Ljava/lang/Object;)V"));
        MatcherAssert.assertThat((Object)SignatureFactory.create(FOO, TypeInfos.VOID).getValue(), (Matcher)Matchers.is((Object)"()V"));
        MatcherAssert.assertThat((Object)SignatureFactory.create(FOO, (TypeInfo)TypeInfos.VOID, TypeInfos.VOID).getValue(), (Matcher)Matchers.is((Object)"(V)V"));
    }

    @Test
    public void testEquals() {
        Signature signature1 = SignatureFactory.create(FOO, (TypeInfo)TypeInfos.OBJECT, TypeInfos.OBJECT);
        Signature signature2 = SignatureFactory.create(FOO, TypeInfos.OBJECT);
        Signature signature3 = SignatureFactory.create(FOO, (TypeInfo)TypeInfos.OBJECT, TypeInfos.OBJECT, TypeInfos.OBJECT);
        Signature signature4 = SignatureFactory.create(BAR, (TypeInfo)TypeInfos.OBJECT, TypeInfos.OBJECT);
        Signature signature5 = SignatureFactory.create(FOO, (TypeInfo)TypeInfos.INTEGER, TypeInfos.OBJECT);
        Signature signature6 = SignatureFactory.create("foo", (TypeInfo)TypeInfos.INTEGER, TypeInfos.OBJECT);
        MatcherAssert.assertThat((Object)signature1.equalsSignature(signature2), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)signature1.equalsSignature(signature3), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)signature1.equalsSignature(signature4), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)signature1.equalsSignature(signature5), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)signature1.equalsSignature(signature6), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testConstructor() {
        Signature signature = SignatureFactory.create("<init>", TypeInfos.VOID);
        MatcherAssert.assertThat((Object)signature.getName(), (Matcher)Matchers.is((Object)"<init>"));
        MatcherAssert.assertThat((Object)signature.getValue(), (Matcher)Matchers.is((Object)"()V"));
        MatcherAssert.assertThat((Object)signature.isConstructor(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testNotConstructor() {
        Signature signature = SignatureFactory.create("foo", TypeInfos.VOID);
        MatcherAssert.assertThat((Object)signature.isConstructor(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testUnresolvedReturnType() {
        Signature signature = SignatureFactory.create("foo", UnresolvedTypeInfoFactory.get());
        MatcherAssert.assertThat((Object)signature.getName(), (Matcher)Matchers.is((Object)"foo"));
    }

    @Test
    public void testUnresolvedParamType() {
        Signature signature = SignatureFactory.create("foo", (TypeInfo)TypeInfos.VOID, UnresolvedTypeInfoFactory.get());
        MatcherAssert.assertThat((Object)signature.getName(), (Matcher)Matchers.is((Object)"foo"));
    }
}

