/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.MemberVisitor;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;

public class SObjectListPeelInfo
implements Variable {
    private final TypeInfo elementType;
    private final Variable variable;

    public SObjectListPeelInfo(TypeInfo listType, Variable variable) {
        assert (SObjectTypeInfoUtil.isSObjectList(listType));
        this.elementType = CollectionTypeInfoUtil.getElementType(listType);
        this.variable = variable;
    }

    @Override
    public String getName() {
        return this.variable.getName();
    }

    @Override
    public Loc getLoc() {
        return this.variable.getLoc();
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.variable.getDefiningType();
    }

    @Override
    public Member.Type getMemberType() {
        return Member.Type.NONE;
    }

    @Override
    public ModifierGroup getModifiers() {
        return this.variable.getModifiers();
    }

    @Override
    public <T> T accept(MemberVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public TypeInfo getType() {
        return this.variable.getType();
    }

    @Override
    public <T> T accept(VariableVisitor<T> visitor, VariableVisitor.Context context) {
        return visitor.visit(this, context);
    }

    public Variable getVariable() {
        return this.variable;
    }

    public TypeInfo getElementType() {
        return this.elementType;
    }
}

