/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.data.JadtTester;
import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.LocalVariableScope;
import apex.jorje.semantic.symbol.member.variable.LocalVariableTable;
import apex.jorje.semantic.symbol.member.variable.StandardLocalVariableTable;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LocalVariableTableTest {
    private static final String NULL_STRING = null;
    private static final LocalInfo LOCAL_BAR = LocalInfo.builder().setName(JadtTester.BAR_ID).setDefiningType(InternalTypeInfos.APEX_OBJECT).setType(TypeInfos.INTEGER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
    private static final LocalInfo LOCAL_FOO = LocalInfo.builder().setName(JadtTester.FOO_ID).setDefiningType(InternalTypeInfos.APEX_OBJECT).setType(TypeInfos.INTEGER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
    private static final LocalInfo LOCAL_NULL = LocalInfo.builder().setName(NULL_STRING).setDefiningType(InternalTypeInfos.APEX_OBJECT).setType(TypeInfos.INTEGER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
    private static final LocalInfo THIS = LocalInfo.buildThis(TypeInfos.INTEGER);
    private LocalVariableTable table;
    private LocalVariableScope firstScope;
    private LocalVariableScope secondScope;

    @BeforeMethod
    public void setUp() throws Exception {
        this.table = new StandardLocalVariableTable();
        this.firstScope = new LocalVariableScope();
        this.secondScope = new LocalVariableScope();
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testAddLocalVariableNoScope() {
        this.table.add(LOCAL_FOO);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPopLocalVariablesNoScope() {
        this.table.pop();
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testAddThisNotLowestScope() {
        this.table.push(this.firstScope);
        this.table.push(this.secondScope);
        this.table.add(THIS).throwIfError();
    }

    @Test
    public void testDuplicateLocalVariables() {
        this.table.push(this.firstScope);
        this.table.add(LOCAL_FOO).throwIfError();
        Result<Void> result = this.table.add(LOCAL_FOO);
        MatcherAssert.assertThat((Object)result.getError(), (Matcher)Matchers.is((Object)I18nSupport.getLabel("duplicate.variable", "Foo")));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testAddThisNotFirstPosition() {
        this.table.push(this.firstScope);
        this.table.add(LOCAL_FOO).throwIfError();
        this.table.add(THIS).throwIfError();
    }

    @Test
    public void testAddThis() {
        this.table.push(this.firstScope);
        this.table.add(THIS).throwIfError();
    }

    @Test
    public void testLookupThisVariable() {
        this.table.push(this.firstScope);
        this.table.add(THIS).throwIfError();
        MatcherAssert.assertThat((Object)this.table.lookup("this", Loc._SyntheticLoc()), (Matcher)Matchers.is((Object)THIS));
    }

    @Test
    public void testLookupLocalVariable() {
        this.table.push(this.firstScope);
        this.table.add(LOCAL_FOO).throwIfError();
        MatcherAssert.assertThat((Object)this.table.lookup(JadtTester.FOO_ID.value, Loc._SyntheticLoc()), (Matcher)Matchers.is((Object)LOCAL_FOO));
    }

    @Test
    public void testLookupNullVariable() {
        this.table.push(this.firstScope);
        this.table.add(LOCAL_NULL).throwIfError();
        MatcherAssert.assertThat((Object)this.table.lookup(NULL_STRING, Loc._SyntheticLoc()), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testScope() {
        this.table.push(this.firstScope);
        this.table.add(LOCAL_FOO).throwIfError();
        this.table.push(this.secondScope);
        this.table.add(LOCAL_BAR).throwIfError();
        MatcherAssert.assertThat((Object)this.table.lookup(JadtTester.FOO_ID.value, Loc._SyntheticLoc()), (Matcher)Matchers.is((Object)LOCAL_FOO));
        MatcherAssert.assertThat((Object)this.table.lookup(JadtTester.BAR_ID.value, Loc._SyntheticLoc()), (Matcher)Matchers.is((Object)LOCAL_BAR));
        this.table.pop();
        MatcherAssert.assertThat((Object)this.table.lookup(JadtTester.FOO_ID.value, Loc._SyntheticLoc()), (Matcher)Matchers.is((Object)LOCAL_FOO));
        MatcherAssert.assertThat((Object)this.table.lookup(JadtTester.BAR_ID.value, Loc._SyntheticLoc()), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testPeek() {
        this.table.push(this.firstScope);
        this.table.push(this.secondScope);
        MatcherAssert.assertThat((Object)this.table.peek(), (Matcher)Matchers.is((Object)this.secondScope));
        this.table.pop();
        MatcherAssert.assertThat((Object)this.table.peek(), (Matcher)Matchers.is((Object)this.firstScope));
    }

    @Test
    public void testNumberOfScopes() {
        MatcherAssert.assertThat((Object)this.table.numberOfScopes(), (Matcher)Matchers.is((Object)0));
        this.table.push(this.firstScope);
        MatcherAssert.assertThat((Object)this.table.numberOfScopes(), (Matcher)Matchers.is((Object)1));
        this.table.push(this.secondScope);
        MatcherAssert.assertThat((Object)this.table.numberOfScopes(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testAllowLazyDeclaration() {
        MatcherAssert.assertThat((Object)this.table.allowLazyDeclaration(), (Matcher)Matchers.is((Object)false));
        this.table.setAllowLazyDeclaration(true);
        MatcherAssert.assertThat((Object)this.table.allowLazyDeclaration(), (Matcher)Matchers.is((Object)true));
        this.table.clearAllowLazyDeclaration();
        MatcherAssert.assertThat((Object)this.table.allowLazyDeclaration(), (Matcher)Matchers.is((Object)false));
    }
}

