/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FinalVariableValidateTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidTriggerData() {
        return new Object[][]{{"trigger FooTrigger on Account (before insert) { final Integer i; void bar(){ i = 5;}}", I18nSupport.getLabel("invalid.final.field.assignment", "i")}, {"trigger FooTrigger on Account (before insert) { final Integer i {get; set;} void bar(){ i = 5;}}", I18nSupport.getLabel("invalid.final.field.assignment", "i")}};
    }

    @Test(dataProvider="invalidTriggerData")
    public void testInvalidTrigger(String source, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(source, expectedError);
    }

    @DataProvider
    Object[][] validTriggerData() {
        return new Object[][]{{"trigger Foo on Account(before insert) { final Integer i; i = 5;}"}, {"trigger Foo on Account(before insert) { final Integer i {get;} }"}, {"trigger Foo on Account(before insert) { final Integer i {get; set;} }"}};
    }

    @Test(dataProvider="validTriggerData")
    public void testValidTrigger(String source) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess(source);
    }

    @DataProvider
    Object[][] validClassData() {
        return new Object[][]{{"void bar() { final Integer i; i = 5;}"}, {"public class Foo { final Integer i; public Foo() { i = 5;} }"}, {"final Integer i {get; set {i = 5;}}"}, {"public class Foo { final Integer i {get; set;} public Foo() { i = 5;} }"}};
    }

    @Test(dataProvider="validClassData")
    public void testValidClass(String source) {
        this.tester.assertSuccess(source);
    }

    @DataProvider
    Object[][] invalidClassData() {
        return new Object[][]{{"final Integer i; void bar() { i = 5;}", I18nSupport.getLabel("invalid.final.field.assignment", "i")}, {"final Integer i {get; set;} void bar() { i = 5;}", I18nSupport.getLabel("invalid.final.field.assignment", "i")}};
    }

    @Test(dataProvider="invalidClassData")
    public void testInvalidClass(String source, String expectedError) {
        this.tester.assertFailure(source, expectedError);
    }
}

