/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.data.JadtTester;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.symbol.member.variable.AbstractFieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardFieldInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.tester.TestSymbolResolvers;
import apex.jorje.semantic.tester.matchers.IsType;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FieldInfoTest {
    private static final SymbolResolver SYMBOLS = TestSymbolResolvers.createEmptySymbols();
    private static final Optional<Expr> VALUE = Optional.of(JadtTester.exprString((String)JadtTester.FOO_ID.value));
    @Mock
    private Property property;

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testNewFieldJAdt() {
        Object field = ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(JadtTester.FOO_ID.value)).setDefiningType(InternalTypeInfos.APEX_OBJECT)).setTypeRef(JadtTester.INTEGER_TYPE)).setModifiers(ModifierGroups.STATEMENT_EXECUTED)).setValue(VALUE)).build(SYMBOLS);
        MatcherAssert.assertThat((Object)((AbstractFieldInfo)field).getName(), (Matcher)Matchers.is((Object)JadtTester.FOO_ID.value));
        MatcherAssert.assertThat((Object)((AbstractFieldInfo)field).getBytecodeName(), (Matcher)Matchers.is((Object)JadtTester.FOO_ID.value));
        MatcherAssert.assertThat((Object)((AbstractFieldInfo)field).getType(), IsType.isType(TypeInfos.INTEGER));
        MatcherAssert.assertThat((Object)((AbstractFieldInfo)field).getModifiers(), (Matcher)Matchers.is((Object)ModifierGroups.STATEMENT_EXECUTED));
        MatcherAssert.assertThat((Object)((AbstractFieldInfo)field).getValue(), (Matcher)Matchers.is((Object)JadtTester.FOO_ID.value));
    }

    @Test
    public void testNewField() {
        Object field = ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(JadtTester.FOO_ID)).setDefiningType(InternalTypeInfos.APEX_OBJECT)).setType(TypeInfos.INTEGER)).setModifiers(ModifierGroups.STATEMENT_EXECUTED)).setValue(Optional.empty())).build();
        MatcherAssert.assertThat((Object)((AbstractFieldInfo)field).getName(), (Matcher)Matchers.is((Object)JadtTester.FOO_ID.value));
        MatcherAssert.assertThat((Object)((AbstractFieldInfo)field).getBytecodeName(), (Matcher)Matchers.is((Object)JadtTester.FOO_ID.value));
        MatcherAssert.assertThat((Object)((AbstractFieldInfo)field).getType(), IsType.isType(TypeInfos.INTEGER));
        MatcherAssert.assertThat((Object)((AbstractFieldInfo)field).getModifiers(), (Matcher)Matchers.is((Object)ModifierGroups.STATEMENT_EXECUTED));
        MatcherAssert.assertThat((Object)((AbstractFieldInfo)field).getValue(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testBytecodeNameTrigger() {
        Object type = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("foo")).setUnitType(UnitType.TRIGGER)).buildResolved();
        Object field = ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(JadtTester.FOO_ID)).setDefiningType((TypeInfo)type)).setType(TypeInfos.INTEGER)).setModifiers(ModifierGroups.GLOBAL_STATIC)).setValue(Optional.empty())).build();
        MatcherAssert.assertThat((Object)field.getBytecodeName(), (Matcher)Matchers.is((Object)JadtTester.FOO_ID.value));
    }

    @Test
    public void testBytecodeNameEnum() {
        Object type = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("foo")).setUnitType(UnitType.ENUM)).buildResolved();
        Object field = ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(JadtTester.FOO_ID)).setDefiningType((TypeInfo)type)).setType(TypeInfos.INTEGER)).setModifiers(ModifierGroups.GLOBAL_STATIC)).setValue(Optional.empty())).build(SYMBOLS);
        MatcherAssert.assertThat((Object)field.getBytecodeName(), (Matcher)Matchers.is((Object)JadtTester.FOO_ID.value));
    }

    @Test
    public void testBytecodeNameClass() {
        Object type = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("foo")).setUnitType(UnitType.CLASS)).buildResolved();
        Object field = ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(JadtTester.FOO_ID)).setDefiningType((TypeInfo)type)).setType(TypeInfos.INTEGER)).setModifiers(ModifierGroups.GLOBAL_STATIC)).setValue(Optional.empty())).build(SYMBOLS);
        MatcherAssert.assertThat((Object)field.getBytecodeName(), (Matcher)Matchers.is((Object)("_static_" + JadtTester.FOO_ID.value)));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testNoName() {
        ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setType(TypeInfos.INTEGER)).setModifiers(ModifierGroups.STATEMENT_EXECUTED)).build(SYMBOLS);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testNoType() {
        ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(JadtTester.FOO_ID)).setModifiers(ModifierGroups.STATEMENT_EXECUTED)).build(SYMBOLS);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testNoModifier() {
        ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(JadtTester.FOO_ID)).setType(TypeInfos.INTEGER)).build(SYMBOLS);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testTypeAlreadySet() {
        ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(JadtTester.FOO_ID)).setType(TypeInfos.INTEGER)).setTypeRef(JadtTester.INTEGER_TYPE)).setModifiers(ModifierGroups.STATEMENT_EXECUTED)).build(SYMBOLS);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testTypeRefAlreadySet() {
        ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(JadtTester.FOO_ID)).setTypeRef(JadtTester.INTEGER_TYPE)).setType(TypeInfos.INTEGER)).setModifiers(ModifierGroups.STATEMENT_EXECUTED)).build(SYMBOLS);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testNoClassType() {
        ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(JadtTester.FOO_ID)).setType(TypeInfos.INTEGER)).setModifiers(ModifierGroups.STATEMENT_EXECUTED)).build(SYMBOLS);
    }
}

