/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.bcl.VfComponentMethods;
import apex.jorje.semantic.common.initializer.Initializer;
import apex.jorje.semantic.common.initializer.Initializers;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.symbol.member.variable.DynamicFieldInfo;
import apex.jorje.semantic.symbol.member.variable.DynamicFieldTable;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.VfComponentTypeInfo;
import com.google.common.base.Strings;

public class DynamicFieldTables {
    private DynamicFieldTables() {
    }

    public static DynamicFieldTable createFacetsTable(VfComponentTypeInfo type) {
        return new DynamicFieldTable((symbols, referencingType, name) -> {
            if (type.hasFacet(name)) {
                return ((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)DynamicFieldInfo.builder().setDefiningType(type)).setType(InternalTypeInfos.APEX_PAGES_COMPONENT)).setModifiers(ModifierGroups.GLOBAL)).setName(name)).setLoadEmitter((emitter, info, context) -> {
                    emitter.push(context.loc, name);
                    emitter.emit(context.loc, VfComponentMethods.getFacet(type));
                }).setStoreEmitter((emitter, info, context) -> {
                    emitter.emit(context.loc, 95);
                    emitter.push(context.loc, name);
                    emitter.emit(context.loc, VfComponentMethods.setFacet(type));
                }).build();
            }
            return null;
        });
    }

    public static DynamicFieldTable createExpressionsTable(VfComponentTypeInfo type) {
        return new DynamicFieldTable((symbols, referencingType, name) -> {
            FieldInfo field = type.fields().get(symbols, referencingType, name, false);
            if (field instanceof DynamicFieldInfo) {
                DynamicFieldInfo dynamicField = (DynamicFieldInfo)field;
                if (!dynamicField.isAllowedInVfExpressions()) {
                    return null;
                }
                return ((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)DynamicFieldInfo.builder().setDefiningType(type)).setType(TypeInfos.STRING)).setModifiers(field.getModifiers())).setName(field.getName())).setLoadEmitter((emitter, info, context) -> {
                    emitter.push(context.loc, field.getName());
                    emitter.emit(context.loc, VfComponentMethods.getExpression(type));
                }).setStoreEmitter((emitter, info, context) -> {
                    emitter.emit(context.loc, 95);
                    emitter.push(context.loc, field.getName());
                    emitter.emit(context.loc, VfComponentMethods.setExpression(type));
                }).build();
            }
            return null;
        });
    }

    public static Initializer<FieldTable, TypeInfo> createLabelTable(final Namespace namespace) {
        return Initializers.memoize(new Initializer<FieldTable, TypeInfo>(){

            @Override
            public FieldTable get(TypeInfo type) {
                return DynamicFieldTables.createLabelTable(type, namespace);
            }
        });
    }

    private static DynamicFieldTable createLabelTable(TypeInfo definingType, Namespace namespace) {
        return new DynamicFieldTable((symbols, referencingType, name) -> {
            if (symbols.getSymbolProvider().hasLabelField(referencingType, namespace, name)) {
                return ((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)DynamicFieldInfo.builder().setDefiningType(definingType)).setType(TypeInfos.STRING)).setModifiers(ModifierGroups.GLOBAL_STATIC)).setNamespace(namespace).setName(name)).setLoadEmitter((emitter, info, context) -> {
                    emitter.push(context.loc, namespace.toString().toLowerCase());
                    emitter.push(context.loc, info.getName().toLowerCase());
                    emitter.emit(context.loc, SystemMethods.getExternalLabel());
                }).build();
            }
            return null;
        });
    }

    public static DynamicFieldTable createPageTable() {
        return new DynamicFieldTable((symbols, referencingType, name) -> {
            String pageReference = symbols.getSymbolProvider().getPageReference(referencingType, name);
            if (!Strings.isNullOrEmpty(pageReference)) {
                TypeInfo pageReferenceType = symbols.lookupTypeInfo(referencingType, InternalTypeInfos.SYSTEM_PAGE_REFERENCE);
                return ((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)DynamicFieldInfo.builder().setDefiningType(symbols.getPageTypeInfo())).setType(pageReferenceType)).setModifiers(ModifierGroups.GLOBAL_STATIC)).setName(name)).setLoadEmitter((emitter, info, context) -> {
                    emitter.emitType(context.loc, 187, pageReferenceType);
                    emitter.emit(context.loc, 89);
                    emitter.push(context.loc, pageReference);
                    emitter.emit(context.loc, ObjectMethods.constructor(pageReferenceType, TypeInfos.STRING));
                }).build();
            }
            return null;
        });
    }
}

