/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodLookupMode;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.StandardMethodTable;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.services.Version;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;

public class MultipleMethodTable
implements MethodTable {
    private final MethodTable nonStaticTable = new StandardMethodTable();
    private final MethodTable staticTable = new StandardMethodTable();

    @Override
    public Result<MethodInfo> getApproximate(Version applicableVersion, Signature signature, MethodLookupMode mode) {
        switch (mode) {
            case STATICS: {
                Result<MethodInfo> method = this.staticTable.getApproximate(applicableVersion, signature, MethodLookupMode.STATICS);
                return method.hasResult() ? method : this.nonStaticTable.getApproximate(applicableVersion, signature, MethodLookupMode.INSTANCE);
            }
            case CONSTRUCTORS: {
                return this.nonStaticTable.getApproximate(applicableVersion, signature, MethodLookupMode.CONSTRUCTORS);
            }
            case INSTANCE: {
                Result<MethodInfo> method = this.nonStaticTable.getApproximate(applicableVersion, signature, MethodLookupMode.INSTANCE);
                return method.hasResult() ? method : this.staticTable.getApproximate(applicableVersion, signature, MethodLookupMode.STATICS);
            }
        }
        throw new UnexpectedCodePathException("unexpected mode: " + (Object)((Object)mode));
    }

    @Override
    public MethodInfo get(Signature signature) {
        MethodInfo method = this.nonStaticTable.get(signature);
        return method == null ? this.staticTable.get(signature) : method;
    }

    @Override
    public MethodInfo remove(Signature signature) {
        MethodInfo method = this.nonStaticTable.remove(signature);
        return method == null ? this.staticTable.remove(signature) : method;
    }

    @Override
    public Result<Void> addNoDuplicatesAllowed(MethodInfo method) {
        return method.getModifiers().has(ModifierTypeInfos.STATIC) ? this.staticTable.addNoDuplicatesAllowed(method) : this.nonStaticTable.addNoDuplicatesAllowed(method);
    }

    @Override
    public Result<Void> addDuplicatesAllowed(MethodInfo method) {
        return method.getModifiers().has(ModifierTypeInfos.STATIC) ? this.staticTable.addDuplicatesAllowed(method) : this.nonStaticTable.addDuplicatesAllowed(method);
    }

    @Override
    public MethodTable resolve() {
        this.staticTable.resolve();
        this.nonStaticTable.resolve();
        return this;
    }

    @Override
    public boolean isResolved() {
        return this.staticTable.isResolved() || this.nonStaticTable.isResolved();
    }

    @Override
    public Collection<MethodInfo> all() {
        return Lists.newArrayList(Iterables.concat(this.staticTable.all(), this.nonStaticTable.all()));
    }

    @Override
    public Collection<MethodInfo> constructors() {
        return this.nonStaticTable.constructors();
    }

    @Override
    public Collection<MethodInfo> statics() {
        return this.staticTable.statics();
    }

    @Override
    public Collection<MethodInfo> instance() {
        return this.nonStaticTable.instance();
    }
}

