/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.semantic.symbol.member.method.MapMethodTable;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.StandardMethodTable;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import java.util.Arrays;

public class MethodTableFactory {
    private MethodTableFactory() {
    }

    public static MethodTable create(MethodInfo ... methods) {
        return MethodTableFactory.create(new StandardMethodTable(), Arrays.asList(methods));
    }

    public static MethodTable create(TypeInfo superType, MethodInfo ... methods) {
        StandardMethodTable table = new StandardMethodTable();
        if (superType != null) {
            for (MethodInfo method : superType.methods().instance()) {
                table.addNoDuplicatesAllowed(method).throwIfError();
            }
        }
        return MethodTableFactory.create(table, Arrays.asList(methods));
    }

    public static MethodTable create(MethodTable table, Iterable<MethodInfo> methods) {
        for (MethodInfo method : methods) {
            table.addNoDuplicatesAllowed(method).throwIfError();
        }
        return table.resolve();
    }

    public static MethodTable createForType(TypeInfo type) {
        return CollectionTypeInfoUtil.isMap(type) ? new MapMethodTable(type) : new StandardMethodTable();
    }
}

