/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodNameMangler;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class MethodNameManglerTest {
    @Test
    public void testMangle() {
        MatcherAssert.assertThat((Object)MethodNameMangler.mangle("<foo, bar>bar:baz.foo "), (Matcher)Is.is((Object)"$$lfoo$$cbar$$rbar$$obaz$$dfoo"));
    }

    @Test
    public void testMangledName() {
        MethodInfo method = StandardMethodInfo.builder().setName("foo").setDefiningType(TypeInfos.OBJECT).setModifiers(ModifierGroups.STATEMENT_EXECUTED).setNamedParameterTypes(ReifiedTypeInfos.INTEGER_LIST).setReturnType(TypeInfos.VOID).setGenerated(Generated.USER).build();
        MatcherAssert.assertThat((Object)MethodNameMangler.getMangledName(method, method.getName()), (Matcher)Is.is((Object)"foo_rvoid_0List$$lInteger$$r"));
    }

    @Test
    public void testConstructorNotMangled() {
        MethodInfo method = StandardMethodInfo.builder().setName("foo").setDefiningType(TypeInfos.OBJECT).setModifiers(ModifierGroups.STATEMENT_EXECUTED).setNamedParameterTypes(ReifiedTypeInfos.INTEGER_LIST).setReturnType(TypeInfos.VOID).setGenerated(Generated.USER).setConstructor().build();
        MatcherAssert.assertThat((Object)MethodNameMangler.getMangledName(method, method.getName()), (Matcher)Is.is((Object)method.getName()));
    }

    @Test
    public void testNonUserNotMangled() {
        MethodInfo method = StandardMethodInfo.builder().setName("foo").setDefiningType(TypeInfos.OBJECT).setModifiers(ModifierGroups.STATEMENT_EXECUTED).setNamedParameterTypes(ReifiedTypeInfos.INTEGER_LIST).setReturnType(TypeInfos.VOID).setGenerated(Generated.BUILT_IN).build();
        MatcherAssert.assertThat((Object)MethodNameMangler.getMangledName(method, method.getName()), (Matcher)Is.is((Object)method.getName()));
    }

    @Test
    public void testUnresolvedSignatureMangled() {
        MethodInfo method = StandardMethodInfo.builder().setName("foo").setDefiningType(TypeInfos.OBJECT).setModifiers(ModifierGroups.STATEMENT_EXECUTED).setNamedParameterTypes(ReifiedTypeInfos.INTEGER_LIST).setGenerated(Generated.USER).setReturnType(UnresolvedTypeInfoFactory.get()).build();
        MatcherAssert.assertThat((Object)MethodNameMangler.getMangledName(method, method.getName()), (Matcher)Is.is((Object)"foo_r!Unresolved!_0List$$lInteger$$r"));
    }

    @Test
    public void testNoFastCallInSignatureNotMangled() {
        MethodInfo method = StandardMethodInfo.builder().setName("foo").setDefiningType(TypeInfos.OBJECT).setModifiers(ModifierGroups.STATEMENT_EXECUTED).setGenerated(Generated.USER).setReturnType(TypeInfos.VOID).build();
        MatcherAssert.assertThat((Object)MethodNameMangler.getMangledName(method, method.getName()), (Matcher)Is.is((Object)method.getName()));
    }

    @DataProvider
    Object[][] hasFastCallTypeData() {
        return new Object[][]{{SignatureFactory.create("foo", (TypeInfo)TypeInfos.INTEGER, TypeInfos.INTEGER), false}, {SignatureFactory.create("foo", (TypeInfo)TypeInfos.LIST, TypeInfos.INTEGER), true}, {SignatureFactory.create("foo", (TypeInfo)TypeInfos.LIST, TypeInfos.INTEGER), true}, {SignatureFactory.create("foo", (TypeInfo)TypeInfos.INTEGER, TypeInfos.LIST), true}, {SignatureFactory.create("foo", (TypeInfo)TypeInfos.INTEGER, TypeInfos.LIST), true}, {SignatureFactory.create("foo", (TypeInfo)TypeInfos.LIST, TypeInfos.INTEGER), true}, {SignatureFactory.create("foo", (TypeInfo)TypeInfos.INTEGER, TypeInfos.LIST), true}};
    }

    @Test(dataProvider="hasFastCallTypeData")
    public void testHasFastCallType(Signature signature, boolean expected) {
        MatcherAssert.assertThat((Object)MethodNameMangler.hasFastCallType(signature), (Matcher)Is.is((Object)expected));
    }

    @Test
    public void testMangleUnreifiedType() {
        MatcherAssert.assertThat((Object)MethodNameMangler.mangle(TypeInfos.LIST), (Matcher)Is.is((Object)"List$$lt$$r"));
    }
}

