/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodLookupMode;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.member.method.StandardMethodTable;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.services.Version;
import java.util.Collection;

public class MapMethodTable
implements MethodTable {
    private final TypeInfo keyType;
    private final TypeInfo valueType;
    private final MethodTable methods;

    public MapMethodTable(TypeInfo mapType) {
        this.keyType = CollectionTypeInfoUtil.getKeyType(mapType);
        this.valueType = CollectionTypeInfoUtil.getValueType(mapType);
        this.methods = new StandardMethodTable();
    }

    @Override
    public Result<MethodInfo> getApproximate(Version applicableVersion, Signature signature, MethodLookupMode mode) {
        Signature newSignature = signature;
        if (signature.getName().equalsIgnoreCase("put") && signature.getParameterTypes().size() == 2) {
            TypeInfo newPutKeyType = this.keyType.equals(TypeInfos.DOUBLE) && TypeInfoEquivalence.isEquivalent(TypeInfos.DECIMAL, signature.getParameterTypes().get(0)) ? TypeInfos.DOUBLE : signature.getParameterTypes().get(0);
            TypeInfo newPutValueType = this.valueType.equals(TypeInfos.DOUBLE) && TypeInfoEquivalence.isEquivalent(TypeInfos.DECIMAL, signature.getParameterTypes().get(1)) ? TypeInfos.DOUBLE : signature.getParameterTypes().get(1);
            newSignature = SignatureFactory.create(signature.getName(), signature.getReturnType(), newPutKeyType, newPutValueType);
        }
        return this.methods.getApproximate(applicableVersion, newSignature, mode);
    }

    @Override
    public MethodInfo get(Signature signature) {
        return this.methods.get(signature);
    }

    @Override
    public MethodInfo remove(Signature signature) {
        return this.methods.remove(signature);
    }

    @Override
    public Result<Void> addNoDuplicatesAllowed(MethodInfo method) {
        return this.methods.addNoDuplicatesAllowed(method);
    }

    @Override
    public Result<Void> addDuplicatesAllowed(MethodInfo method) {
        return this.methods.addDuplicatesAllowed(method);
    }

    @Override
    public MethodTable resolve() {
        this.methods.resolve();
        return this;
    }

    @Override
    public boolean isResolved() {
        return this.methods.isResolved();
    }

    @Override
    public Collection<MethodInfo> all() {
        return this.methods.all();
    }

    @Override
    public Collection<MethodInfo> constructors() {
        return this.methods.constructors();
    }

    @Override
    public Collection<MethodInfo> statics() {
        return this.methods.statics();
    }

    @Override
    public Collection<MethodInfo> instance() {
        return this.methods.instance();
    }
}

