/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodLookupMode;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.member.method.StandardMethodTable;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.services.Version;
import java.util.Collection;

public class JavaMethodTable
implements MethodTable {
    private final StandardMethodTable methods = new StandardMethodTable();

    @Override
    public Result<MethodInfo> getApproximate(Version applicableVersion, Signature signature, MethodLookupMode mode) {
        return this.methods.getApproximate(applicableVersion, this.normalizeForJavaParameterTypes(signature), mode);
    }

    @Override
    public MethodInfo get(Signature signature) {
        return this.methods.get(this.normalizeForJavaParameterTypes(signature));
    }

    @Override
    public MethodInfo remove(Signature signature) {
        return this.methods.remove(signature);
    }

    @Override
    public Result<Void> addNoDuplicatesAllowed(MethodInfo method) {
        return this.methods.addNoDuplicatesAllowed(method);
    }

    @Override
    public Result<Void> addDuplicatesAllowed(MethodInfo method) {
        return this.methods.addDuplicatesAllowed(method);
    }

    @Override
    public MethodTable resolve() {
        this.methods.resolve();
        return this;
    }

    @Override
    public boolean isResolved() {
        return this.methods.isResolved();
    }

    @Override
    public Collection<MethodInfo> all() {
        return this.methods.all();
    }

    @Override
    public Collection<MethodInfo> constructors() {
        return this.methods.constructors();
    }

    @Override
    public Collection<MethodInfo> statics() {
        return this.methods.statics();
    }

    @Override
    public Collection<MethodInfo> instance() {
        return this.methods.instance();
    }

    private Signature normalizeForJavaParameterTypes(Signature signature) {
        return SignatureFactory.create(signature.getName(), signature.getReturnType(), signature.getParameterTypes().stream().map(type -> {
            switch (type.getBasicType()) {
                case LIST: {
                    return ReifiedTypeInfos.OBJECT_LIST;
                }
                case SET: {
                    return ReifiedTypeInfos.OBJECT_SET;
                }
                case MAP: {
                    return ReifiedTypeInfos.STRING_TO_OBJECT_MAP;
                }
            }
            return type;
        }).collect(MoreIterables.toUnmodifiableList(signature.getParameterTypes().size())));
    }
}

