/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.semantic.common.iterable.CaseInsensitiveSet;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.member.IdentifierValidator;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoTables;
import apex.jorje.semantic.tester.TestConstants;
import apex.jorje.services.Version;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class IdentifierValidatorTest {
    private static final String VALID_IDENTIFIER = "a_1foo0bar24";
    private static final Set<String> VALID_NAMES = CaseInsensitiveSet.builder().addAll(IdentifierValidator.VALID_SCALAR_AS_IDENTIFIERS.stream().map(TypeInfo.TO_APEX_NAME).collect(Collectors.toSet())).build();
    @Mock
    private SourceFile source;
    private TypeInfo definingType;

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.definingType = ((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setFileBase(this.source, CompilationUnitBuilder.emptyClass((String)"foo"))).buildResolved();
        Mockito.when((Object)((Object)this.source.getVersion())).thenReturn((Object)Version.CURRENT);
    }

    @Test
    public void testReserved() {
        for (IdentifierValidator.Type type : IdentifierValidator.Type.values()) {
            IdentifierValidator.Check expected = type == IdentifierValidator.Type.METHOD ? IdentifierValidator.Check.VALID : IdentifierValidator.Check.RESERVED_NAME;
            this.testReserved(expected, IdentifierValidator.RESERVED, type);
        }
    }

    @Test
    public void testScalar() {
        Sets.SetView<String> invalidNames = Sets.difference(TypeInfoTables.TYPES_BY_APEX_NAME.keySet(), VALID_NAMES);
        for (IdentifierValidator.Type type : IdentifierValidator.Type.values()) {
            IdentifierValidator.Check expected = type == IdentifierValidator.Type.METHOD ? IdentifierValidator.Check.VALID : IdentifierValidator.Check.RESERVED_NAME;
            this.testReserved(expected, invalidNames, type);
        }
        for (IdentifierValidator.Type type : IdentifierValidator.Type.values()) {
            this.testReserved(IdentifierValidator.Check.VALID, VALID_NAMES, type);
        }
    }

    @Test
    public void testVersionedScalar() {
        Mockito.when((Object)((Object)this.source.getVersion())).thenReturn((Object)Version.MIN);
        ImmutableSet<String> versionedNames = ImmutableSet.of("time");
        for (IdentifierValidator.Type type : IdentifierValidator.Type.values()) {
            this.testReserved(IdentifierValidator.Check.VALID, versionedNames, type);
        }
    }

    @Test
    public void testReservedType() {
        for (IdentifierValidator.Type type : IdentifierValidator.Type.values()) {
            IdentifierValidator.Check expected = type == IdentifierValidator.Type.CLASS || type == IdentifierValidator.Type.INTERFACE || type == IdentifierValidator.Type.EXCEPTION ? IdentifierValidator.Check.RESERVED_TYPE : IdentifierValidator.Check.VALID;
            this.testReserved(expected, IdentifierValidator.RESERVED_TYPE, type);
        }
    }

    private void testReserved(IdentifierValidator.Check expected, Collection<String> reservedSet, IdentifierValidator.Type type) {
        for (String name : reservedSet) {
            MatcherAssert.assertThat((String)(name + " should not be valid for " + (Object)((Object)type)), (Object)((Object)IdentifierValidator.get().check(this.definingType, name, type, false)), (Matcher)Is.is((Object)((Object)expected)));
        }
    }

    @Test
    public void testMaxLength() {
        for (IdentifierValidator.Type type : IdentifierValidator.Type.values()) {
            MatcherAssert.assertThat((Object)((Object)IdentifierValidator.get().check(this.definingType, Strings.repeat("a", 256), type, true)), (Matcher)Is.is((Object)((Object)IdentifierValidator.Check.TOO_LONG)));
        }
    }

    @Test
    public void testTrustedClassNameMaxLength() {
        this.definingType = ((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setFileBase(TestConstants.TRUSTED_SOURCE, CompilationUnitBuilder.emptyClass((String)"foo"))).buildResolved();
        MatcherAssert.assertThat((Object)((Object)IdentifierValidator.get().check(this.definingType, Strings.repeat("a", 256), IdentifierValidator.Type.CLASS, true)), (Matcher)Is.is((Object)((Object)IdentifierValidator.Check.TOO_LONG)));
    }

    @Test
    public void testNonTrustedClassNameMaxLength() {
        MatcherAssert.assertThat((Object)((Object)IdentifierValidator.get().check(this.definingType, Strings.repeat("a", 41), IdentifierValidator.Type.CLASS, true)), (Matcher)Is.is((Object)((Object)IdentifierValidator.Check.TOO_LONG)));
    }

    @Test
    public void testInvalidCharacter() {
        for (IdentifierValidator.Type type : IdentifierValidator.Type.values()) {
            MatcherAssert.assertThat((Object)((Object)IdentifierValidator.get().check(this.definingType, "5", type, false)), (Matcher)Is.is((Object)((Object)IdentifierValidator.Check.INVALID_CHARACTER)));
        }
    }

    @Test
    public void testInvalidCharacters() {
        MatcherAssert.assertThat((Object)IdentifierValidator.get().hasValidCharacters("a"), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)IdentifierValidator.get().hasValidCharacters("$"), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)IdentifierValidator.get().hasValidCharacters("_"), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)IdentifierValidator.get().hasValidCharacters("5"), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)IdentifierValidator.get().hasValidCharacters("a_"), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)IdentifierValidator.get().hasValidCharacters("a%"), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)IdentifierValidator.get().hasValidCharacters("a$"), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)IdentifierValidator.get().hasValidCharacters("a__5"), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)IdentifierValidator.get().hasValidCharacters(""), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)IdentifierValidator.get().hasValidCharacters(VALID_IDENTIFIER), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testValidName() {
        for (IdentifierValidator.Type type : IdentifierValidator.Type.values()) {
            MatcherAssert.assertThat((Object)((Object)IdentifierValidator.get().check(this.definingType, VALID_IDENTIFIER, type, true)), (Matcher)Is.is((Object)((Object)IdentifierValidator.Check.VALID)));
        }
    }
}

