/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.exception;

import apex.jorje.data.Loc;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.services.exception.CompilationException;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.PrinterUtil;
import com.google.common.base.Objects;
import java.util.List;

public class SemanticException
extends CompilationException {
    private final Loc loc;
    private final String error;

    public SemanticException(Loc loc, String error) {
        super(PrinterUtil.get().getFactory().loc().print(loc, new PrintContext()) + ": " + error);
        this.loc = loc;
        this.error = error;
    }

    public static List<SemanticException> create(Loc loc, List<String> messages) {
        return messages.stream().map(message -> new SemanticException(loc, (String)message)).collect(MoreIterables.toUnmodifiableList(messages.size()));
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    @Override
    public String getError() {
        return this.error;
    }

    public int hashCode() {
        return Objects.hashCode(this.loc, this.error);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemanticException that = (SemanticException)o;
        return Objects.equal(this.loc, that.loc) && Objects.equal(this.error, that.error);
    }
}

