/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class NamespaceFactoryTest {
    @DataProvider
    Object[][] parseData() {
        return new Object[][]{{"namespace__module", Namespaces.create("namespace", "module")}, {"namespace", Namespaces.create("namespace")}, {"name_space", Namespaces.create("name_space")}};
    }

    @Test(dataProvider="parseData")
    public void testParse(String name, Namespace expected) {
        MatcherAssert.assertThat((Object)Namespaces.parse(name), (Matcher)Matchers.is((Object)expected));
    }

    @DataProvider
    Object[][] createNamespaceData() {
        return new Object[][]{{"namespace", new Namespace("namespace", null)}};
    }

    @Test(dataProvider="createNamespaceData")
    public void testCreateNamespace(String namespace, Namespace expected) {
        MatcherAssert.assertThat((Object)Namespaces.create(namespace), (Matcher)Matchers.is((Object)expected));
    }

    @DataProvider
    Object[][] createNamespaceModuleData() {
        return new Object[][]{{"namespace", "module", new Namespace("namespace", "module")}};
    }

    @Test(dataProvider="createNamespaceModuleData")
    public void testCreateNamespaceModule(String namespace, String module, Namespace expected) {
        MatcherAssert.assertThat((Object)Namespaces.create(namespace, module), (Matcher)Matchers.is((Object)expected));
    }
}

