/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.MemberResolveVisitor;
import apex.jorje.semantic.ast.visitor.ParentVisitor;
import apex.jorje.semantic.ast.visitor.PostTypeResolveVisitor;
import apex.jorje.semantic.compiler.ApexCompiler;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.CompilerStage;
import apex.jorje.semantic.symbol.member.variable.LocalVariableTable;
import apex.jorje.semantic.symbol.member.variable.StandardLocalVariableTable;
import apex.jorje.semantic.symbol.resolver.FieldContext;
import apex.jorje.semantic.symbol.resolver.StandardSymbolResolver;
import apex.jorje.semantic.symbol.resolver.StaticContext;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Queues;
import java.util.Deque;

public final class CompilerContext {
    private final SymbolResolver symbols;
    private final Emitter emitter;
    private final ParentVisitor parentVisitor;
    private final MemberResolveVisitor memberResolveVisitor;
    private final PostTypeResolveVisitor postTypeResolveVisitor;
    private final Deque<CompilerStage> currentStages;
    private final Deque<LocalContext> localContexts;
    private final AstVisitor<AdditionalPassScope> additionalPassVisitor;
    private final BiMap<TypeInfo, CodeUnit> typeInfoToCodeUnit;

    CompilerContext(ApexCompiler compiler) {
        this.symbols = new StandardSymbolResolver(compiler);
        this.emitter = new Emitter();
        this.parentVisitor = new ParentVisitor();
        this.memberResolveVisitor = new MemberResolveVisitor();
        this.postTypeResolveVisitor = new PostTypeResolveVisitor();
        this.currentStages = Queues.newArrayDeque();
        this.localContexts = Queues.newArrayDeque();
        this.additionalPassVisitor = compiler.getInput().getAdditionalPassVisitor();
        this.typeInfoToCodeUnit = HashBiMap.create();
    }

    public SymbolResolver getSymbolResolver() {
        return this.symbols;
    }

    Emitter getEmitter() {
        return this.emitter;
    }

    ParentVisitor getParentVisitor() {
        return this.parentVisitor;
    }

    MemberResolveVisitor getMemberResolveVisitor() {
        return this.memberResolveVisitor;
    }

    PostTypeResolveVisitor getPostTypeResolveVisitor() {
        return this.postTypeResolveVisitor;
    }

    Deque<CompilerStage> getCurrentStages() {
        return this.currentStages;
    }

    Deque<LocalContext> getLocalContexts() {
        return this.localContexts;
    }

    public AstVisitor<AdditionalPassScope> getAdditionalPassVisitor() {
        return this.additionalPassVisitor;
    }

    public LocalVariableTable variables() {
        this.ensureLocalContext();
        return this.localContexts.peek().variables;
    }

    public StaticContext staticContext() {
        this.ensureLocalContext();
        return this.localContexts.peek().staticContext;
    }

    public FieldContext fieldContext() {
        this.ensureLocalContext();
        return this.localContexts.peek().fieldContext;
    }

    private void ensureLocalContext() {
        if (this.localContexts.isEmpty()) {
            this.localContexts.push(new LocalContext());
        }
    }

    public BiMap<TypeInfo, CodeUnit> getTypeInfoToCodeUnit() {
        return this.typeInfoToCodeUnit;
    }

    public void addTypeInfoCodeUnit(TypeInfo typeInfo, CodeUnit codeUnit) {
        this.typeInfoToCodeUnit.put(typeInfo, codeUnit);
    }

    public static class LocalContext {
        private final LocalVariableTable variables = new StandardLocalVariableTable();
        private final StaticContext staticContext = new StaticContext();
        private final FieldContext fieldContext = new FieldContext();

        LocalContext() {
        }
    }
}

