/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.ApiVersionVisitor;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.ast.visitor.ValueScope;
import apex.jorje.semantic.ast.visitor.reference.ExternalDependency;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.compiler.CompilationOutput;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.parser.ParserOutput;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;

public class CodeUnit {
    private final ParserWrapper parser;
    private final Errors errors;
    private SourceFile source;
    private Compilation node;
    private ListMultimap<TypeInfo, ExternalDependency> references;

    public CodeUnit(ParserWrapper parser, SourceFile source) {
        this.parser = parser;
        this.source = source;
        this.errors = new Errors();
    }

    @SfdcCalled
    public SourceFile getSourceFile() {
        return this.source;
    }

    public boolean updateVersion() {
        Version version;
        if (this.source.isFileBased() && (version = ValueScope.evaluate(this.node, ApiVersionVisitor.get(), Version.CURRENT)) != Version.CURRENT) {
            this.source = this.source.copy().setVersion(version).build();
            return true;
        }
        return false;
    }

    public void reparse() {
        this.errors.clear();
        this.parse();
    }

    public void parse() {
        block2: {
            try {
                ParserOutput output = this.parser.parse(this.source);
                this.node = AstNodeFactory.create(this.errors, this.source, null, output.getUnit());
                this.errors.addAll(output.getParseErrors());
                this.errors.addAll(output.getInternalErrors());
            }
            catch (StackOverflowError e) {
                this.errors.markInvalid(I18nSupport.getLabel("expression.too.long"));
                if (this.node != null) break block2;
                this.node = Compilation.INVALID;
            }
        }
    }

    @SfdcCalled
    public CompilationOutput getOutput() {
        return this.node != null ? this.node.getOutput() : null;
    }

    @SfdcCalled
    public CompilationOutput getOutput(String bytecodeName) {
        CompilationOutput innerOutput = this.getOutput().getInnerOutputs().get(bytecodeName);
        if (innerOutput != null) {
            return innerOutput;
        }
        assert (this.getType().getBytecodeName().equalsIgnoreCase(bytecodeName)) : "no such output on this node: " + bytecodeName;
        return this.getOutput();
    }

    public TypeInfo getType() {
        return this.node.getDefiningType();
    }

    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (this.node != null) {
            this.node.traverse(visitor, scope);
        }
    }

    public void validate(SymbolResolver symbols) {
        if (this.node != null) {
            this.node.validate(symbols, new ValidationScope(symbols, this.errors));
        }
    }

    public void additionalValidate(AstVisitor<AdditionalPassScope> visitor) {
        if (this.node != null) {
            this.node.traverse(visitor, new AdditionalPassScope(this.errors));
        }
    }

    public void emit(Emitter emitter) {
        if (this.errors.isEmpty()) {
            this.node.emit(emitter);
        }
    }

    public Errors getErrors() {
        return this.errors;
    }

    public String toString() {
        return this.source.toString();
    }

    @SfdcCalled
    public ListMultimap<TypeInfo, ExternalDependency> getReferences() {
        Preconditions.checkNotNull(this.references, "Code unit references not resolved yet!");
        return this.references;
    }

    public void setReferences(ListMultimap<TypeInfo, ExternalDependency> references) {
        this.references = references;
    }

    public Compilation getNode() {
        return this.node;
    }

    public String getName() {
        return this.getType() != null ? this.getType().getCodeUnitDetails().getName() : this.source.getKnownName();
    }

    public Namespace getNamespace() {
        return this.source.getNamespace();
    }
}

